/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.dataRep;

public class SimpleInterval
implements Comparable<SimpleInterval> {
    public long L;
    public long R;

    public SimpleInterval() {
        this.L = 0L;
        this.R = 1L;
    }

    public SimpleInterval(long l, long r) {
        this.L = l;
        this.R = r;
    }

    public SimpleInterval(SimpleInterval o) {
        this.L = o.L;
        this.R = o.R;
    }

    public String toString() {
        return "[" + this.L + ", " + this.R + ")";
    }

    public boolean equals(Object o) {
        SimpleInterval other = (SimpleInterval)o;
        return other.L == this.L && other.R == this.R;
    }

    public int hashCode() {
        int ans = (int)((this.L + this.R) % Integer.MAX_VALUE);
        if (ans < 0) {
            ans = -ans;
        }
        return ans;
    }

    @Override
    public int compareTo(SimpleInterval o) {
        if (this.L == o.L) {
            return this.R < o.R ? -1 : 1;
        }
        return this.L < o.L ? -1 : 1;
    }

    public boolean contains(SimpleInterval o) {
        SimpleInterval osi = o;
        return this.L <= osi.L && this.R >= osi.R;
    }

    public boolean merge(SimpleInterval o) {
        SimpleInterval osi = o;
        if (osi.L < this.L) {
            if (this.L <= osi.R) {
                this.L = osi.L;
                if (this.R < osi.R) {
                    this.R = osi.R;
                }
                return true;
            }
        } else if (osi.L <= this.R) {
            if (this.R < osi.R) {
                this.R = osi.R;
            }
            return true;
        }
        return false;
    }

    public boolean intersect(SimpleInterval o) {
        SimpleInterval osi = o;
        return this.L <= osi.L && osi.L < this.R || osi.L <= this.L && this.L < osi.R;
    }
}

