/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.TypeSwitch;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.toolkits.typing.fast.WeakObjectType;
import soot.util.ArrayNumberer;
import soot.util.BitVector;
import soot.util.queue.QueueReader;

public final class TypeManager {
    private Map<SootClass, List<AllocNode>> class2allocs = new HashMap<SootClass, List<AllocNode>>(1024);
    private List<AllocNode> anySubtypeAllocs = new LinkedList<AllocNode>();
    private static final Logger logger = LoggerFactory.getLogger(TypeManager.class);
    protected final RefType rtObject;
    protected final RefType rtSerializable;
    protected final RefType rtCloneable;
    private Map<Type, BitVector> typeMask = null;
    protected Supplier<FastHierarchy> fh = null;
    protected PAG pag;
    protected QueueReader<AllocNode> allocNodeListener = null;

    public TypeManager(PAG pag) {
        this.pag = pag;
        this.rtObject = Scene.v().getObjectType();
        this.rtSerializable = RefType.v("java.io.Serializable");
        this.rtCloneable = RefType.v("java.lang.Cloneable");
    }

    public static boolean isUnresolved(Type type) {
        SootClass cl;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            type = at.getArrayElementType();
        }
        if (!(type instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)type;
        if (!rt.hasSootClass()) {
            if (rt instanceof WeakObjectType) {
                SootClass c = Scene.v().forceResolve(rt.getClassName(), 1);
                if (c == null) {
                    return true;
                }
                rt.setSootClass(c);
            } else {
                return true;
            }
        }
        return (cl = rt.getSootClass()).resolvingLevel() < 1;
    }

    public final BitVector get(Type type) {
        if (type == null) {
            return null;
        }
        Scene sc = Scene.v();
        while (this.allocNodeListener.hasNext()) {
            AllocNode n = this.allocNodeListener.next();
            if (n == null) continue;
            Type nt = n.getType();
            Iterable<Type> types = nt instanceof NullType || nt instanceof AnySubType ? sc.getTypeNumberer() : sc.getOrMakeFastHierarchy().canStoreTypeList(nt);
            for (Type t : types) {
                if (!(t instanceof RefLikeType) || t instanceof AnySubType || TypeManager.isUnresolved(t)) continue;
                BitVector mask = this.typeMask.get(t);
                if (mask == null) {
                    mask = new BitVector();
                    this.typeMask.put(t, mask);
                    for (AllocNode an : this.pag.getAllocNodeNumberer()) {
                        if (!this.castNeverFails(an.getType(), t)) continue;
                        mask.set(an.getNumber());
                    }
                    continue;
                }
                mask.set(n.getNumber());
            }
        }
        BitVector ret = this.typeMask.get(type);
        if (ret == null && this.fh != null && type instanceof RefType) {
            SootClass curClass = ((RefType)type).getSootClass();
            if (curClass.isPhantom()) {
                return new BitVector();
            }
            while (curClass.hasSuperclass()) {
                curClass = curClass.getSuperclass();
                if (!(type instanceof RefType) || !curClass.isPhantom()) continue;
                return new BitVector();
            }
            logger.warn("Type mask not found for type " + type + ". This is casued by a cast operation to a type which is a phantom class and no type mask was found. This may affect the precision of the point-to set.");
            BitVector soundOverApproxRet = new BitVector();
            for (int i = 0; i <= 63; ++i) {
                soundOverApproxRet.set(i);
            }
            return soundOverApproxRet;
        }
        return ret;
    }

    public final void clearTypeMask() {
        this.typeMask = null;
    }

    public final void makeTypeMask() {
        RefType.v("java.lang.Class");
        this.typeMask = new HashMap<Type, BitVector>();
        if (this.fh == null) {
            return;
        }
        this.initClass2allocs();
        this.makeClassTypeMask(Scene.v().getSootClass(Scene.v().getObjectType().getClassName()));
        BitVector visitedTypes = new BitVector();
        for (Type t : this.typeMask.keySet()) {
            visitedTypes.set(t.getNumber());
        }
        ArrayNumberer<AllocNode> allocNodes = this.pag.getAllocNodeNumberer();
        for (Type t : Scene.v().getTypeNumberer()) {
            if (!(t instanceof RefLikeType) || t instanceof AnySubType || TypeManager.isUnresolved(t)) continue;
            if (t instanceof RefType && t != this.rtObject && t != this.rtSerializable && t != this.rtCloneable) {
                RefType rt = (RefType)t;
                SootClass sc = rt.getSootClass();
                if (sc.isInterface()) {
                    this.makeMaskOfInterface(sc);
                }
                if (visitedTypes.get(t.getNumber()) || rt.getSootClass().isPhantom()) continue;
                this.makeClassTypeMask(rt.getSootClass());
                continue;
            }
            BitVector mask = new BitVector(allocNodes.size());
            for (Node node : allocNodes) {
                if (!this.castNeverFails(node.getType(), t)) continue;
                mask.set(node.getNumber());
            }
            this.typeMask.put(t, mask);
        }
        this.allocNodeListener = this.pag.allocNodeListener();
    }

    public final boolean castNeverFails(Type src, Type dst) {
        if (dst == null) {
            return true;
        }
        if (dst == src) {
            return true;
        }
        if (src == null) {
            return false;
        }
        if (src instanceof NullType) {
            return true;
        }
        if (src instanceof AnySubType) {
            return true;
        }
        if (dst instanceof NullType) {
            return false;
        }
        if (dst instanceof AnySubType) {
            throw new RuntimeException("oops src=" + src + " dst=" + dst);
        }
        FastHierarchy fh = this.getFastHierarchy();
        if (fh == null) {
            return true;
        }
        return fh.canStoreType(src, dst);
    }

    public void setFastHierarchy(Supplier<FastHierarchy> fh) {
        this.fh = fh;
    }

    public FastHierarchy getFastHierarchy() {
        return this.fh == null ? null : this.fh.get();
    }

    private void initClass2allocs() {
        for (AllocNode an : this.pag.getAllocNodeNumberer()) {
            this.addAllocNode(an);
        }
    }

    private final void addAllocNode(final AllocNode alloc) {
        alloc.getType().apply(new TypeSwitch(){

            @Override
            public final void caseRefType(RefType t) {
                SootClass cl = t.getSootClass();
                LinkedList<AllocNode> list = (LinkedList<AllocNode>)TypeManager.this.class2allocs.get(cl);
                if (list == null) {
                    list = new LinkedList<AllocNode>();
                    TypeManager.this.class2allocs.put(cl, list);
                }
                list.add(alloc);
            }

            @Override
            public final void caseAnySubType(AnySubType t) {
                TypeManager.this.anySubtypeAllocs.add(alloc);
            }
        });
    }

    private final BitVector makeClassTypeMask(SootClass clazz) {
        Collection<SootClass> subclasses;
        BitVector cachedMask = this.typeMask.get(clazz.getType());
        if (cachedMask != null) {
            return cachedMask;
        }
        int nBits = this.pag.getAllocNodeNumberer().size();
        BitVector mask = new BitVector(nBits);
        List<AllocNode> allocs = null;
        if (clazz.isConcrete()) {
            allocs = this.class2allocs.get(clazz);
        }
        if (allocs != null) {
            for (AllocNode an : allocs) {
                mask.set(an.getNumber());
            }
        }
        if ((subclasses = this.fh.get().getSubclassesOf(clazz)) == Collections.EMPTY_LIST) {
            for (AllocNode an : this.anySubtypeAllocs) {
                mask.set(an.getNumber());
            }
            this.typeMask.put(clazz.getType(), mask);
            return mask;
        }
        for (SootClass subcl : subclasses) {
            mask.or(this.makeClassTypeMask(subcl));
        }
        this.typeMask.put(clazz.getType(), mask);
        return mask;
    }

    private final BitVector makeMaskOfInterface(SootClass interf) {
        if (!interf.isInterface()) {
            throw new RuntimeException();
        }
        BitVector ret = new BitVector(this.pag.getAllocNodeNumberer().size());
        this.typeMask.put(interf.getType(), ret);
        Set<SootClass> implementers = this.getFastHierarchy().getAllImplementersOfInterface(interf);
        for (SootClass impl : implementers) {
            BitVector other = this.typeMask.get(impl.getType());
            if (other == null) {
                other = this.makeClassTypeMask(impl);
            }
            ret.or(other);
        }
        if (implementers.size() == 0) {
            for (AllocNode an : this.anySubtypeAllocs) {
                ret.set(an.getNumber());
            }
        }
        return ret;
    }
}

