/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand.pautil;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.spark.ondemand.genericutil.DisjointSets;

public final class OTFMethodSCCManager {
    private DisjointSets disj;
    private Map<SootMethod, Integer> numbers = new HashMap<SootMethod, Integer>();

    public OTFMethodSCCManager() {
        int num = 0;
        for (SootClass c : Scene.v().getClasses()) {
            for (SootMethod m : c.getMethods()) {
                this.numbers.put(m, num++);
            }
        }
        this.disj = new DisjointSets(num + 1);
    }

    public boolean inSameSCC(SootMethod m1, SootMethod m2) {
        return this.disj.find(this.numbers.get(m1)) == this.disj.find(this.numbers.get(m2));
    }

    public void makeSameSCC(Set<SootMethod> methods) {
        SootMethod prevMethod = null;
        for (SootMethod method : methods) {
            int methodRep;
            int prevMethodRep;
            if (prevMethod != null && (prevMethodRep = this.disj.find(this.numbers.get(prevMethod))) != (methodRep = this.disj.find(this.numbers.get(method)))) {
                this.disj.union(prevMethodRep, methodRep);
            }
            prevMethod = method;
        }
    }
}

