/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Iterator;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.HashSparseSet;

public class ClinitElimAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<SootMethod>> {
    private final CallGraph cg = Scene.v().getCallGraph();
    private final UnitGraph g;
    private static FlowSet<SootMethod> cachedFlowSet = null;

    public ClinitElimAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.doAnalysis();
    }

    @Override
    public void merge(FlowSet<SootMethod> in1, FlowSet<SootMethod> in2, FlowSet<SootMethod> out) {
        in1.intersection(in2, out);
    }

    @Override
    public void copy(FlowSet<SootMethod> src, FlowSet<SootMethod> dest) {
        src.copy(dest);
    }

    @Override
    protected void copyFreshToExisting(FlowSet<SootMethod> in, FlowSet<SootMethod> dest) {
        in.copyFreshToExisting(dest);
    }

    @Override
    protected void flowThrough(FlowSet<SootMethod> inVal, Unit stmt, FlowSet<SootMethod> outVal) {
        inVal.copy(outVal);
        Iterator<Edge> edges = this.cg.edgesOutOf(stmt);
        while (edges.hasNext()) {
            Edge e = edges.next();
            if (!e.isClinit()) continue;
            outVal.add(e.tgt());
        }
    }

    @Override
    protected FlowSet<SootMethod> entryInitialFlow() {
        return new HashSparseSet<SootMethod>();
    }

    @Override
    protected FlowSet<SootMethod> newInitialFlow() {
        HashSparseSet<SootMethod> returnedFlowSet = new HashSparseSet<SootMethod>();
        if (cachedFlowSet == null) {
            cachedFlowSet = this.calculateInitialFlow();
        }
        cachedFlowSet.copy(returnedFlowSet);
        return returnedFlowSet;
    }

    protected FlowSet<SootMethod> calculateInitialFlow() {
        HashSparseSet<SootMethod> newFlowSet = new HashSparseSet<SootMethod>();
        Iterator<Edge> mIt = this.cg.edgesOutOf(this.g.getBody().getMethod());
        while (mIt.hasNext()) {
            Edge edge = mIt.next();
            if (!edge.isClinit()) continue;
            newFlowSet.add(edge.tgt());
        }
        return newFlowSet;
    }
}

