/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class SlowCallGraph
extends CallGraph {
    private final Set<Edge> edges = new HashSet<Edge>();
    private final MultiMap<Unit, Edge> unitMap = new HashMultiMap<Unit, Edge>();
    private final MultiMap<MethodOrMethodContext, Edge> srcMap = new HashMultiMap<MethodOrMethodContext, Edge>();
    private final MultiMap<MethodOrMethodContext, Edge> tgtMap = new HashMultiMap<MethodOrMethodContext, Edge>();
    private final ChunkedQueue<Edge> stream = new ChunkedQueue();
    private final QueueReader<Edge> reader = this.stream.reader();

    @Override
    public boolean addEdge(Edge e) {
        if (this.edges.add(e)) {
            this.stream.add(e);
            this.srcMap.put(e.getSrc(), e);
            this.tgtMap.put(e.getTgt(), e);
            this.unitMap.put(e.srcUnit(), e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEdge(Edge e) {
        if (this.edges.remove(e)) {
            this.srcMap.remove(e.getSrc(), e);
            this.tgtMap.remove(e.getTgt(), e);
            this.unitMap.remove(e.srcUnit(), e);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MethodOrMethodContext> sourceMethods() {
        return new ArrayList<MethodOrMethodContext>(this.srcMap.keySet()).iterator();
    }

    @Override
    public Iterator<Edge> edgesOutOf(Unit u) {
        return new ArrayList<Edge>(this.unitMap.get(u)).iterator();
    }

    @Override
    public Iterator<Edge> edgesOutOf(MethodOrMethodContext m) {
        return new ArrayList<Edge>(this.srcMap.get(m)).iterator();
    }

    @Override
    public Iterator<Edge> edgesInto(MethodOrMethodContext m) {
        return new ArrayList<Edge>(this.tgtMap.get(m)).iterator();
    }

    @Override
    public QueueReader<Edge> listener() {
        return this.reader.clone();
    }

    @Override
    public QueueReader<Edge> newListener() {
        return this.stream.reader();
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        QueueReader<Edge> rdr = this.listener();
        while (rdr.hasNext()) {
            Edge e = rdr.next();
            if (e == null) continue;
            out.append(e.toString()).append('\n');
        }
        return out.toString();
    }

    @Override
    public int size() {
        return this.edges.size();
    }
}

