/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Body;
import soot.ClassMember;
import soot.Hierarchy;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public class AccessManager {
    public static boolean isAccessLegal(SootMethod container2, ClassMember target) {
        SootClass targetClass = target.getDeclaringClass();
        if (!AccessManager.isAccessLegal(container2, targetClass)) {
            return false;
        }
        SootClass containerClass = container2.getDeclaringClass();
        if (target.isPrivate() && !targetClass.getName().equals(containerClass.getName())) {
            return false;
        }
        if (!(target.isPrivate() || target.isProtected() || target.isPublic() || targetClass.getPackageName().equals(containerClass.getPackageName()))) {
            return false;
        }
        if (target.isProtected() && !targetClass.getPackageName().equals(containerClass.getPackageName())) {
            Hierarchy h = Scene.v().getActiveHierarchy();
            return h.isClassSuperclassOfIncluding(targetClass, containerClass);
        }
        return true;
    }

    public static boolean isAccessLegal(SootMethod container2, SootClass target) {
        return target.isPublic() || container2.getDeclaringClass().getPackageName().equals(target.getPackageName());
    }

    public static boolean isAccessLegal(SootMethod container2, Stmt stmt) {
        if (stmt.containsInvokeExpr()) {
            return AccessManager.isAccessLegal(container2, stmt.getInvokeExpr().getMethod());
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt as = (AssignStmt)stmt;
            Value rightOp = as.getRightOp();
            if (rightOp instanceof FieldRef) {
                return AccessManager.isAccessLegal(container2, ((FieldRef)rightOp).getField());
            }
            Value leftOp = as.getLeftOp();
            if (leftOp instanceof FieldRef) {
                return AccessManager.isAccessLegal(container2, ((FieldRef)leftOp).getField());
            }
        }
        return true;
    }

    public static void createAccessorMethods(Body body, Stmt before, Stmt after) {
        UnitPatchingChain units = body.getUnits();
        if (before != null && !units.contains(before) || after != null && !units.contains(after)) {
            throw new RuntimeException();
        }
        boolean bInside = before == null;
        for (Unit unit : new ArrayList<Unit>(units)) {
            Stmt s = (Stmt)unit;
            if (bInside) {
                if (s == after) {
                    return;
                }
                SootMethod m = body.getMethod();
                if (AccessManager.isAccessLegal(m, s)) continue;
                AccessManager.createAccessorMethod(m, s);
                continue;
            }
            if (s != before) continue;
            bInside = true;
        }
    }

    public static String createAccessorName(ClassMember member, boolean setter) {
        StringBuilder name = new StringBuilder("access$");
        if (member instanceof SootField) {
            name.append(setter ? "set$" : "get$");
            SootField f = (SootField)member;
            name.append(f.getName());
        } else {
            SootMethod m = (SootMethod)member;
            name.append(m.getName()).append('$');
            for (Type type : m.getParameterTypes()) {
                name.append(type.toString().replaceAll("\\.", "\\$\\$")).append('$');
            }
        }
        return name.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createAccessorMethod(SootMethod container2, Stmt stmt) {
        if (!container2.getActiveBody().getUnits().contains(stmt)) {
            throw new RuntimeException();
        }
        if (stmt.containsInvokeExpr()) {
            AccessManager.createInvokeAccessor(container2, stmt);
            return;
        } else {
            if (!(stmt instanceof AssignStmt)) throw new RuntimeException("Expected class member access");
            AssignStmt as = (AssignStmt)stmt;
            Value leftOp = as.getLeftOp();
            if (leftOp instanceof FieldRef) {
                AccessManager.createSetAccessor(container2, as, (FieldRef)leftOp);
                return;
            } else {
                Value rightOp = as.getRightOp();
                if (!(rightOp instanceof FieldRef)) throw new RuntimeException("Expected class member access");
                AccessManager.createGetAccessor(container2, as, (FieldRef)rightOp);
            }
        }
    }

    private static void createGetAccessor(SootMethod container2, AssignStmt as, FieldRef ref) {
        String name;
        Jimple jimp = Jimple.v();
        SootClass target = ref.getField().getDeclaringClass();
        SootMethod accessor = target.getMethodByNameUnsafe(name = AccessManager.createAccessorName(ref.getField(), false));
        if (accessor == null) {
            List<Type> parameterTypes;
            JimpleBody accessorBody = jimp.newBody();
            UnitPatchingChain accStmts = accessorBody.getUnits();
            LocalGenerator lg = Scene.v().createLocalGenerator(accessorBody);
            RefType targetType = target.getType();
            Local thisLocal = lg.generateLocal(targetType);
            if (ref instanceof InstanceFieldRef) {
                accStmts.addFirst(jimp.newIdentityStmt(thisLocal, jimp.newParameterRef(targetType, 0)));
                parameterTypes = Collections.singletonList(targetType);
            } else {
                parameterTypes = Collections.emptyList();
            }
            Type refFieldType = ref.getField().getType();
            Local l = lg.generateLocal(refFieldType);
            accStmts.add(jimp.newAssignStmt(l, ref instanceof InstanceFieldRef ? jimp.newInstanceFieldRef(thisLocal, ref.getFieldRef()) : jimp.newStaticFieldRef(ref.getFieldRef())));
            accStmts.add(jimp.newReturnStmt(l));
            accessor = Scene.v().makeSootMethod(name, parameterTypes, refFieldType, 9, Collections.emptyList());
            accessorBody.setMethod(accessor);
            accessor.setActiveBody(accessorBody);
            target.addMethod(accessor);
        }
        List args = ref instanceof InstanceFieldRef ? Collections.singletonList(((InstanceFieldRef)ref).getBase()) : Collections.emptyList();
        as.setRightOp(jimp.newStaticInvokeExpr(accessor.makeRef(), args));
    }

    private static void createSetAccessor(SootMethod container2, AssignStmt as, FieldRef ref) {
        String name;
        Jimple jimp = Jimple.v();
        SootClass target = ref.getField().getDeclaringClass();
        SootMethod accessor = target.getMethodByNameUnsafe(name = AccessManager.createAccessorName(ref.getField(), true));
        if (accessor == null) {
            JimpleBody accessorBody = jimp.newBody();
            UnitPatchingChain accStmts = accessorBody.getUnits();
            LocalGenerator lg = Scene.v().createLocalGenerator(accessorBody);
            Local thisLocal = lg.generateLocal(target.getType());
            ArrayList<Type> parameterTypes = new ArrayList<Type>(2);
            int paramID = 0;
            if (ref instanceof InstanceFieldRef) {
                accStmts.add(jimp.newIdentityStmt(thisLocal, jimp.newParameterRef(target.getType(), paramID)));
                parameterTypes.add(target.getType());
                ++paramID;
            }
            parameterTypes.add(ref.getField().getType());
            Local l = lg.generateLocal(ref.getField().getType());
            accStmts.add(jimp.newIdentityStmt(l, jimp.newParameterRef(ref.getField().getType(), paramID)));
            ++paramID;
            if (ref instanceof InstanceFieldRef) {
                accStmts.add(jimp.newAssignStmt(jimp.newInstanceFieldRef(thisLocal, ref.getFieldRef()), l));
            } else {
                accStmts.add(jimp.newAssignStmt(jimp.newStaticFieldRef(ref.getFieldRef()), l));
            }
            accStmts.addLast(jimp.newReturnVoidStmt());
            accessor = Scene.v().makeSootMethod(name, parameterTypes, VoidType.v(), 9, Collections.emptyList());
            accessorBody.setMethod(accessor);
            accessor.setActiveBody(accessorBody);
            target.addMethod(accessor);
        }
        ArrayList<Value> args = new ArrayList<Value>(2);
        if (ref instanceof InstanceFieldRef) {
            args.add(((InstanceFieldRef)ref).getBase());
        }
        args.add(as.getRightOp());
        UnitPatchingChain containerStmts = container2.getActiveBody().getUnits();
        containerStmts.insertAfter(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(accessor.makeRef(), args)), as);
        containerStmts.remove(as);
    }

    private static void createInvokeAccessor(SootMethod container2, Stmt stmt) {
        String name;
        Jimple jimp = Jimple.v();
        InvokeExpr expr = stmt.getInvokeExpr();
        SootMethod method = expr.getMethod();
        SootClass target = method.getDeclaringClass();
        SootMethod accessor = target.getMethodByNameUnsafe(name = AccessManager.createAccessorName(method, true));
        if (accessor == null) {
            Stmt s;
            Local thisLocal;
            InvokeExpr accExpr;
            JimpleBody accessorBody = jimp.newBody();
            UnitPatchingChain accStmts = accessorBody.getUnits();
            LocalGenerator lg = Scene.v().createLocalGenerator(accessorBody);
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            if (expr instanceof InstanceInvokeExpr) {
                parameterTypes.add(target.getType());
            }
            parameterTypes.addAll(method.getParameterTypes());
            ArrayList<Local> arguments = new ArrayList<Local>();
            int paramID = 0;
            for (Type type : parameterTypes) {
                Local l = lg.generateLocal(type);
                accStmts.add(jimp.newIdentityStmt(l, jimp.newParameterRef(type, paramID)));
                arguments.add(l);
                ++paramID;
            }
            if (expr instanceof StaticInvokeExpr) {
                accExpr = jimp.newStaticInvokeExpr(method.makeRef(), arguments);
            } else if (expr instanceof VirtualInvokeExpr) {
                thisLocal = (Local)arguments.get(0);
                arguments.remove(0);
                accExpr = jimp.newVirtualInvokeExpr(thisLocal, method.makeRef(), arguments);
            } else if (expr instanceof SpecialInvokeExpr) {
                thisLocal = (Local)arguments.get(0);
                arguments.remove(0);
                accExpr = jimp.newSpecialInvokeExpr(thisLocal, method.makeRef(), arguments);
            } else {
                throw new RuntimeException();
            }
            Type returnType = method.getReturnType();
            if (returnType instanceof VoidType) {
                s = jimp.newInvokeStmt(accExpr);
                accStmts.add(s);
                accStmts.add(jimp.newReturnVoidStmt());
            } else {
                Local resultLocal = lg.generateLocal(returnType);
                s = jimp.newAssignStmt(resultLocal, accExpr);
                accStmts.add(s);
                accStmts.add(jimp.newReturnStmt(resultLocal));
            }
            accessor = Scene.v().makeSootMethod(name, parameterTypes, returnType, 9, method.getExceptions());
            accessorBody.setMethod(accessor);
            accessor.setActiveBody(accessorBody);
            target.addMethod(accessor);
        }
        ArrayList<Value> args = new ArrayList<Value>();
        if (expr instanceof InstanceInvokeExpr) {
            args.add(((InstanceInvokeExpr)expr).getBase());
        }
        args.addAll(expr.getArgs());
        stmt.getInvokeExprBox().setValue(jimp.newStaticInvokeExpr(accessor.makeRef(), args));
    }

    public static boolean ensureAccess(SootMethod container2, ClassMember target, String options) {
        SootClass targetClass = target.getDeclaringClass();
        if (!AccessManager.ensureAccess(container2, targetClass, options)) {
            return false;
        }
        if (AccessManager.isAccessLegal(container2, target)) {
            return true;
        }
        if (!targetClass.isApplicationClass()) {
            return false;
        }
        if (options != null) {
            switch (options) {
                case "none": {
                    return false;
                }
                case "accessors": {
                    return true;
                }
                case "unsafe": {
                    target.setModifiers(target.getModifiers() | 1);
                    return true;
                }
            }
        }
        throw new RuntimeException("Not implemented yet!");
    }

    public static boolean ensureAccess(SootMethod container2, SootClass target, String options) {
        if (AccessManager.isAccessLegal(container2, target)) {
            return true;
        }
        if (options != null) {
            switch (options) {
                case "accessors": {
                    return false;
                }
                case "none": {
                    return false;
                }
                case "unsafe": {
                    if (target.isApplicationClass()) {
                        target.setModifiers(target.getModifiers() | 1);
                        return true;
                    }
                    return false;
                }
            }
        }
        throw new RuntimeException("Not implemented yet!");
    }

    private AccessManager() {
    }
}

