/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.jimple.toolkits.scalar.pre.LatestComputation;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;

public class NotIsolatedAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet<EquivalentValue>> {
    private final LatestComputation unitToLatest;
    private final Map<Unit, EquivalentValue> unitToGen;
    private final FlowSet<EquivalentValue> set;

    public NotIsolatedAnalysis(DirectedGraph<Unit> dg, LatestComputation latest, Map<Unit, EquivalentValue> equivRhsMap) {
        this(dg, latest, equivRhsMap, new ArrayPackedSet<EquivalentValue>(new CollectionFlowUniverse<EquivalentValue>(equivRhsMap.values())));
    }

    public NotIsolatedAnalysis(DirectedGraph<Unit> dg, LatestComputation latest, Map<Unit, EquivalentValue> equivRhsMap, BoundedFlowSet<EquivalentValue> set) {
        super(dg);
        this.set = set;
        this.unitToGen = equivRhsMap;
        this.unitToLatest = latest;
        this.doAnalysis();
    }

    @Override
    protected FlowSet<EquivalentValue> newInitialFlow() {
        return this.set.emptySet();
    }

    @Override
    protected FlowSet<EquivalentValue> entryInitialFlow() {
        return this.newInitialFlow();
    }

    @Override
    protected void flowThrough(FlowSet<EquivalentValue> in, Unit unit, FlowSet<EquivalentValue> out) {
        in.copy(out);
        EquivalentValue rhs = this.unitToGen.get(unit);
        if (rhs != null) {
            out.add(rhs);
        }
        FlowSet<EquivalentValue> latest = this.unitToLatest.getFlowBefore(unit);
        out.difference(latest);
    }

    @Override
    protected void merge(FlowSet<EquivalentValue> inSet1, FlowSet<EquivalentValue> inSet2, FlowSet<EquivalentValue> outSet) {
        inSet1.union(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet<EquivalentValue> sourceSet, FlowSet<EquivalentValue> destSet) {
        sourceSet.copy(destSet);
    }
}

