/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.DominatorsFinder;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.tagkit.Tag;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class DfsForBackEdge {
    private final Map<Object, Object> backEdges = new HashMap<Object, Object>();
    private final Set<Object> gray = new HashSet<Object>();
    private final Set<Object> black = new HashSet<Object>();
    private final DominatorsFinder domFinder;

    DfsForBackEdge(Chain chain, DirectedGraph peg) {
        this.domFinder = new DominatorsFinder(chain, peg);
        Iterator it = chain.iterator();
        this.dfs(it, peg);
        this.testBackEdge();
    }

    private void dfs(Iterator it, DirectedGraph g) {
        while (it.hasNext()) {
            Object s = it.next();
            if (this.gray.contains(s)) continue;
            this.visitNode(g, s);
        }
    }

    private void visitNode(DirectedGraph g, Object s) {
        this.gray.add(s);
        Iterator<Object> it = g.getSuccsOf(s).iterator();
        if (g.getSuccsOf(s).size() > 0) {
            while (it.hasNext()) {
                FlowSet dominators;
                Object succ = it.next();
                if (!this.gray.contains(succ)) {
                    this.visitNode(g, succ);
                    continue;
                }
                if (!this.gray.contains(succ) || this.black.contains(succ) || !(dominators = this.domFinder.getDominatorsOf(s)).contains(succ)) continue;
                System.out.println("s is " + s);
                System.out.println("succ is " + succ);
                this.backEdges.put(s, succ);
            }
        }
        this.black.add(s);
    }

    protected Map<Object, Object> getBackEdges() {
        return this.backEdges;
    }

    private void testBackEdge() {
        System.out.println("===test backEdges==");
        Set<Map.Entry<Object, Object>> maps = this.backEdges.entrySet();
        for (Map.Entry<Object, Object> entry : maps) {
            JPegStmt key = (JPegStmt)entry.getKey();
            Tag tag = key.getTags().get(0);
            System.out.println("---key=  " + tag + " " + key);
            JPegStmt value = (JPegStmt)entry.getValue();
            Tag tag1 = value.getTags().get(0);
            System.out.println("---value=  " + tag1 + " " + value);
        }
        System.out.println("===test backEdges==end==");
    }
}

