/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Type;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.ITypingStrategy;
import soot.jimple.toolkits.typing.fast.TypeResolver;
import soot.jimple.toolkits.typing.fast.Typing;
import soot.util.Chain;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class DefaultTypingStrategy
implements ITypingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTypingStrategy.class);
    public static final ITypingStrategy INSTANCE = new DefaultTypingStrategy();
    public static boolean MINIMIZING_ENABLED = true;
    public static int USE_PARALLEL_MINIMIZE_IF_ENTRIES_MORE_THAN = 1000;

    @Override
    public Typing createTyping(Chain<Local> locals) {
        return new Typing(locals);
    }

    @Override
    public Typing createTyping(Typing tg) {
        return new Typing(tg);
    }

    public static MultiMap<Local, Type> getFlatTyping(List<Typing> tgs) {
        HashMultiMap<Local, Type> map = new HashMultiMap<Local, Type>();
        for (Typing tg : tgs) {
            map.putMap(tg.map);
        }
        return map;
    }

    public static Set<Local> getObjectLikeTypings(List<Typing> tgs) {
        HashSet<RefType> objectLikeTypeSet = new HashSet<RefType>();
        objectLikeTypeSet.add(Scene.v().getObjectType());
        objectLikeTypeSet.add(RefType.v("java.io.Serializable"));
        objectLikeTypeSet.add(RefType.v("java.lang.Cloneable"));
        HashSet<Local> objectLikeVars = new HashSet<Local>();
        MultiMap<Local, Type> ft = DefaultTypingStrategy.getFlatTyping(tgs);
        for (Local l : ft.keySet()) {
            if (!objectLikeTypeSet.equals(ft.get(l))) continue;
            objectLikeVars.add(l);
        }
        return objectLikeVars;
    }

    @Override
    public void minimize(List<Typing> tgs, IHierarchy h) {
        if (!MINIMIZING_ENABLED) {
            return;
        }
        if (tgs.size() > USE_PARALLEL_MINIMIZE_IF_ENTRIES_MORE_THAN) {
            this.minimizeParallel(tgs, h);
            return;
        }
        this.minimizeSequential(tgs, h);
    }

    public void minimizeSequential(List<Typing> tgs, IHierarchy h) {
        Set<Local> objectVars = DefaultTypingStrategy.getObjectLikeTypings(tgs);
        ListIterator<Typing> i = tgs.listIterator();
        block0: while (i.hasNext()) {
            Typing tgi = i.next();
            if (tgi == null) {
                i.remove();
                continue;
            }
            ListIterator<Typing> j = tgs.listIterator(i.nextIndex());
            while (j.hasNext()) {
                Typing tgj = j.next();
                if (tgj == null) continue;
                int comp = this.compare(tgi, tgj, h, objectVars);
                if (comp == 1) {
                    i.remove();
                    continue block0;
                }
                if (comp != -1) continue;
                j.set(null);
            }
        }
    }

    public int compare(Typing a, Typing b, IHierarchy h, Collection<Local> localsToIgnore) {
        int r = 0;
        for (Local v : a.map.keySet()) {
            int cmp;
            Type tb;
            if (localsToIgnore.contains(v)) continue;
            Type ta = a.get(v);
            if (TypeResolver.typesEqual(ta, tb = b.get(v))) {
                cmp = 0;
            } else if (h.ancestor(ta, tb)) {
                cmp = 1;
                if (r == -1) {
                    return 2;
                }
            } else if (h.ancestor(tb, ta)) {
                cmp = -1;
                if (r == 1) {
                    return 2;
                }
            } else {
                return -2;
            }
            if (r != 0) continue;
            r = cmp;
        }
        return r;
    }

    public void minimizeParallel(List<Typing> tgs, IHierarchy h) {
        logger.debug("Performing parallel minimization");
        Set<Local> objectVars = DefaultTypingStrategy.getObjectLikeTypings(tgs);
        ArrayList<Typing> workList = new ArrayList<Typing>(tgs);
        AtomicInteger processed = new AtomicInteger();
        int tgsSize = tgs.size();
        IntStream.range(0, tgsSize).parallel().forEach(i -> {
            Typing tgi;
            int count = processed.incrementAndGet();
            if (count % 1000 == 0) {
                logger.debug("minimizing {} = {}%", (Object)count, (Object)Float.valueOf(100.0f * (float)count / (float)tgsSize));
            }
            if ((tgi = (Typing)workList.get(i)) == null) {
                return;
            }
            ListIterator j = workList.listIterator(i + 1);
            while (j.hasNext()) {
                Typing tgj = (Typing)j.next();
                if (tgj == null) continue;
                int comp = this.compare(tgi, tgj, h, objectVars);
                if (comp == 1) {
                    workList.set(i, null);
                    return;
                }
                if (comp != -1) continue;
                j.set(null);
            }
        });
        for (int i2 = tgsSize - 1; i2 >= 0; --i2) {
            if (workList.get(i2) != null) continue;
            tgs.remove(i2);
        }
        int diff = tgsSize - tgs.size();
        if (diff > 0) {
            logger.debug("Minimizing has removed {} of {} typing", (Object)diff, (Object)tgsSize);
        }
    }

    @Override
    public void finalizeTypes(Typing tp) {
        for (Local l : tp.getAllLocals()) {
            Type t = tp.get(l);
            if (t.isAllowedInFinalCode()) continue;
            tp.set(l, t.getDefaultFinalType());
        }
    }
}

