/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.util.FastStack;

public class StronglyConnectedComponentsFast<N> {
    protected final List<List<N>> componentList = new ArrayList<List<N>>();
    protected final List<List<N>> trueComponentList = new ArrayList<List<N>>();
    protected int index = 0;
    protected Map<N, Integer> indexForNode;
    protected Map<N, Integer> lowlinkForNode;
    protected FastStack<N> s;
    protected DirectedGraph<N> g;

    public StronglyConnectedComponentsFast(DirectedGraph<N> g) {
        this.g = g;
        this.s = new FastStack();
        this.indexForNode = new HashMap<N, Integer>();
        this.lowlinkForNode = new HashMap<N, Integer>();
        for (N node : g) {
            if (this.indexForNode.containsKey(node)) continue;
            if (g.size() > 1000) {
                this.iterate(node);
                continue;
            }
            this.recurse(node);
        }
        this.indexForNode = null;
        this.lowlinkForNode = null;
        this.s = null;
        this.g = null;
    }

    protected void recurse(N v) {
        this.indexForNode.put(v, this.index);
        int lowLinkForNodeV = this.index++;
        this.lowlinkForNode.put(v, lowLinkForNodeV);
        this.s.push(v);
        for (N succ : this.g.getSuccsOf(v)) {
            Integer indexForNodeSucc = this.indexForNode.get(succ);
            if (indexForNodeSucc == null) {
                this.recurse(succ);
                lowLinkForNodeV = Math.min(lowLinkForNodeV, this.lowlinkForNode.get(succ));
                this.lowlinkForNode.put(v, lowLinkForNodeV);
                continue;
            }
            if (!this.s.contains(succ)) continue;
            lowLinkForNodeV = Math.min(lowLinkForNodeV, indexForNodeSucc);
            this.lowlinkForNode.put(v, lowLinkForNodeV);
        }
        if (lowLinkForNodeV == this.indexForNode.get(v)) {
            N v2;
            ArrayList<N> scc = new ArrayList<N>();
            do {
                v2 = this.s.pop();
                scc.add(v2);
            } while (v != v2);
            this.componentList.add(scc);
            if (scc.size() > 1) {
                this.trueComponentList.add(scc);
            } else {
                Object n = scc.get(0);
                if (this.g.getSuccsOf(n).contains(n)) {
                    this.trueComponentList.add(scc);
                }
            }
        }
    }

    protected void iterate(N x) {
        ArrayList<Object> workList = new ArrayList<Object>();
        ArrayList backtrackList = new ArrayList();
        workList.add(x);
        while (!workList.isEmpty()) {
            N v2;
            int lowLinkForNodeV;
            Object v = workList.remove(0);
            boolean hasChildren = false;
            boolean isForward = false;
            if (!this.indexForNode.containsKey(v)) {
                this.indexForNode.put(v, this.index);
                this.lowlinkForNode.put(v, this.index);
                ++this.index;
                this.s.push(v);
                isForward = true;
            }
            for (N succ : this.g.getSuccsOf(v)) {
                int lowLinkForNodeV2;
                Integer indexForNodeSucc = this.indexForNode.get(succ);
                if (indexForNodeSucc == null) {
                    workList.add(0, succ);
                    hasChildren = true;
                    break;
                }
                if (!isForward) {
                    lowLinkForNodeV2 = this.lowlinkForNode.get(v);
                    this.lowlinkForNode.put(v, Math.min(lowLinkForNodeV2, this.lowlinkForNode.get(succ)));
                    continue;
                }
                if (!isForward || !this.s.contains(succ)) continue;
                lowLinkForNodeV2 = this.lowlinkForNode.get(v);
                this.lowlinkForNode.put(v, Math.min(lowLinkForNodeV2, indexForNodeSucc));
            }
            if (hasChildren) {
                backtrackList.add(0, v);
                continue;
            }
            if (!backtrackList.isEmpty()) {
                workList.add(0, backtrackList.remove(0));
            }
            if ((lowLinkForNodeV = this.lowlinkForNode.get(v).intValue()) != this.indexForNode.get(v)) continue;
            ArrayList<N> scc = new ArrayList<N>();
            do {
                v2 = this.s.pop();
                scc.add(v2);
            } while (v != v2);
            this.componentList.add(scc);
            if (scc.size() > 1) {
                this.trueComponentList.add(scc);
                continue;
            }
            Object n = scc.get(0);
            if (!this.g.getSuccsOf(n).contains(n)) continue;
            this.trueComponentList.add(scc);
        }
    }

    public List<List<N>> getComponents() {
        return this.componentList;
    }

    public List<List<N>> getTrueComponents() {
        return this.trueComponentList;
    }
}

