/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;

public class ConstantValueToInitializerTransformer
extends SceneTransformer {
    public static ConstantValueToInitializerTransformer v() {
        return new ConstantValueToInitializerTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        for (SootClass sc : Scene.v().getClasses()) {
            this.transformClass(sc);
        }
    }

    public void transformClass(SootClass sc) {
        UnitPatchingChain units;
        Jimple jimp = Jimple.v();
        SootMethod smInit = null;
        HashSet<SootField> alreadyInitialized = new HashSet<SootField>();
        for (SootField sf : sc.getFields()) {
            if (alreadyInitialized.contains(sf)) continue;
            for (Tag t : sf.getTags()) {
                Constant constant = null;
                if (t instanceof DoubleConstantValueTag) {
                    double value = ((DoubleConstantValueTag)t).getDoubleValue();
                    constant = DoubleConstant.v(value);
                } else if (t instanceof FloatConstantValueTag) {
                    float value = ((FloatConstantValueTag)t).getFloatValue();
                    constant = FloatConstant.v(value);
                } else if (t instanceof IntegerConstantValueTag) {
                    int value = ((IntegerConstantValueTag)t).getIntValue();
                    constant = IntConstant.v(value);
                } else if (t instanceof LongConstantValueTag) {
                    long value = ((LongConstantValueTag)t).getLongValue();
                    constant = LongConstant.v(value);
                } else if (t instanceof StringConstantValueTag) {
                    String value = ((StringConstantValueTag)t).getStringValue();
                    constant = StringConstant.v(value);
                }
                if (constant == null) continue;
                if (sf.isStatic()) {
                    AssignStmt initStmt = jimp.newAssignStmt(jimp.newStaticFieldRef(sf.makeRef()), constant);
                    if (smInit == null) {
                        smInit = this.getOrCreateInitializer(sc, alreadyInitialized);
                    }
                    if (smInit == null) continue;
                    smInit.getActiveBody().getUnits().addFirst(initStmt);
                    continue;
                }
                block2: for (SootMethod m : sc.getMethods()) {
                    if (!m.isConstructor()) continue;
                    Body body = m.retrieveActiveBody();
                    UnitPatchingChain units2 = body.getUnits();
                    Local thisLocal = null;
                    if (this.isInstanceFieldAssignedConstantInBody(sf, constant, body)) continue;
                    for (Unit u : units2) {
                        InvokeExpr expr;
                        Stmt s;
                        if (!(u instanceof Stmt) || !(s = (Stmt)u).containsInvokeExpr() || !((expr = s.getInvokeExpr()) instanceof SpecialInvokeExpr)) continue;
                        if (expr.getMethod().getDeclaringClass() == sc) continue block2;
                        if (thisLocal == null) {
                            thisLocal = body.getThisLocal();
                        }
                        AssignStmt initStmt = jimp.newAssignStmt(jimp.newInstanceFieldRef(thisLocal, sf.makeRef()), constant);
                        units2.insertAfter(initStmt, s);
                        continue block2;
                    }
                }
            }
        }
        if (smInit != null && ((units = smInit.getActiveBody().getUnits()).isEmpty() || !(units.getLast() instanceof ReturnVoidStmt))) {
            units.add(jimp.newReturnVoidStmt());
        }
    }

    private boolean isInstanceFieldAssignedConstantInBody(SootField sf, Constant constant, Body body) {
        for (Unit u : body.getUnits()) {
            InstanceFieldRef ifr;
            AssignStmt as;
            if (!(u instanceof AssignStmt) || !(as = (AssignStmt)u).containsFieldRef() || !(as.getFieldRef() instanceof InstanceFieldRef) || !as.getLeftOpBox().equals(as.getFieldRefBox()) || !as.getRightOp().equivTo(constant) || !(ifr = (InstanceFieldRef)as.getFieldRef()).getField().equals(sf) || !ifr.getBase().equivTo(body.getThisLocal())) continue;
            return true;
        }
        return false;
    }

    private SootMethod getOrCreateInitializer(SootClass sc, Set<SootField> alreadyInitialized) {
        SootMethod smInit = sc.getMethodByNameUnsafe("<clinit>");
        if (smInit == null) {
            smInit = Scene.v().makeSootMethod("<clinit>", Collections.emptyList(), VoidType.v());
            smInit.setActiveBody(Jimple.v().newBody(smInit));
            sc.addMethod(smInit);
            smInit.setModifiers(9);
        } else {
            if (smInit.isPhantom()) {
                return null;
            }
            for (Unit u : smInit.retrieveActiveBody().getUnits()) {
                Stmt s = (Stmt)u;
                for (ValueBox vb : s.getDefBoxes()) {
                    Value value = vb.getValue();
                    if (!(value instanceof FieldRef)) continue;
                    alreadyInitialized.add(((FieldRef)value).getField());
                }
            }
        }
        return smInit;
    }
}

