/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.interprocedural.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.analysis.interprocedural.icfg.BiDiInterproceduralCFG;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootMethod;
import sootup.core.views.View;

public abstract class AbstractJimpleBasedICFG
implements BiDiInterproceduralCFG<Stmt, SootMethod> {
    protected final boolean enableExceptions;
    protected View view;
    @DontSynchronize(value="written by single thread; read afterwards")
    private final Map<Stmt, Body> stmtToOwner = this.createStmtToOwnerMap();
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected LoadingCache<Body, StmtGraph<?>> bodyToStmtGraph = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Body, StmtGraph<?>>(){

        @Nonnull
        public StmtGraph<?> load(@Nonnull Body body) {
            return AbstractJimpleBasedICFG.this.makeGraph(body);
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected LoadingCache<SootMethod, List<Value>> methodToParameterRefs = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, List<Value>>(){

        @Nonnull
        public List<Value> load(@Nonnull SootMethod m) {
            return new ArrayList<Value>(m.getBody().getParameterLocals());
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected LoadingCache<SootMethod, Set<Stmt>> methodToCallsFromWithin = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, Set<Stmt>>(){

        @Nonnull
        public Set<Stmt> load(@Nonnull SootMethod m) {
            return AbstractJimpleBasedICFG.this.getCallsFromWithinMethod(m);
        }
    });

    protected AbstractJimpleBasedICFG() {
        this(true);
    }

    protected Map<Stmt, Body> createStmtToOwnerMap() {
        return new IdentityHashMap<Stmt, Body>();
    }

    protected AbstractJimpleBasedICFG(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public Body getBodyOf(Stmt stmt) {
        Body body = this.stmtToOwner.get(stmt);
        assert (body != null) : "Statement " + stmt + " not in Stmt-to-owner mapping";
        return body;
    }

    public SootMethod getMethodOf(Stmt stmt) {
        Body b = this.getBodyOf(stmt);
        if (b == null) {
            return null;
        }
        return this.view.getMethod(b.getMethodSignature()).orElse(null);
    }

    public List<Stmt> getSuccsOf(Stmt stmt) {
        Body body = this.getBodyOf(stmt);
        if (body == null) {
            return Collections.emptyList();
        }
        StmtGraph<?> stmtGraph = this.getOrCreateStmtGraph(body);
        return stmtGraph.successors(stmt);
    }

    @Override
    public StmtGraph<?> getOrCreateStmtGraph(SootMethod method) {
        return this.getOrCreateStmtGraph(method.getBody());
    }

    @Override
    public StmtGraph<?> getOrCreateStmtGraph(Body body) {
        return (StmtGraph)this.bodyToStmtGraph.getUnchecked((Object)body);
    }

    protected StmtGraph<?> makeGraph(Body body) {
        return body.getStmtGraph();
    }

    protected Set<Stmt> getCallsFromWithinMethod(SootMethod method) {
        return method.getBody().getStmts().stream().filter(this::isCallStmt).collect(Collectors.toSet());
    }

    public boolean isExitStmt(Stmt stmt) {
        Body body = this.getBodyOf(stmt);
        StmtGraph<?> stmtGraph = this.getOrCreateStmtGraph(body);
        return stmtGraph.getTails().contains(stmt);
    }

    public boolean isStartPoint(Stmt stmt) {
        Body body = this.getBodyOf(stmt);
        StmtGraph<?> stmtGraph = this.getOrCreateStmtGraph(body);
        return stmtGraph.getEntrypoints().contains(stmt);
    }

    public boolean isFallThroughSuccessor(Stmt stmt, Stmt successorCandidate) {
        assert (this.getSuccsOf(stmt).contains(successorCandidate));
        if (!stmt.fallsThrough()) {
            return false;
        }
        Body body = this.getBodyOf(stmt);
        return body.getStmtGraph().successors(stmt).get(0) == successorCandidate;
    }

    public boolean isBranchTarget(Stmt u, Stmt succ) {
        assert (this.getSuccsOf(u).contains(succ));
        return u.branches();
    }

    @Override
    public List<Value> getParameterRefs(SootMethod m) {
        return (List)this.methodToParameterRefs.getUnchecked((Object)m);
    }

    public Collection<Stmt> getStartPointsOf(SootMethod m) {
        if (!m.hasBody()) {
            return Collections.emptySet();
        }
        Body body = m.getBody();
        StmtGraph<?> stmtGraph = this.getOrCreateStmtGraph(body);
        return stmtGraph.getEntrypoints();
    }

    public boolean setOwnerStatement(Stmt u, Body b) {
        return this.stmtToOwner.put(u, b) == null;
    }

    public boolean isCallStmt(Stmt stmt) {
        return stmt.isInvokableStmt() && stmt.asInvokableStmt().containsInvokeExpr();
    }

    public Set<Stmt> allNonCallStartNodes() {
        return this.stmtToOwner.keySet().stream().filter(u -> !this.isStartPoint((Stmt)u) && !this.isCallStmt((Stmt)u)).collect(Collectors.toSet());
    }

    @Override
    public Set<Stmt> allNonCallEndNodes() {
        return this.stmtToOwner.keySet().stream().filter(u -> !this.isExitStmt((Stmt)u) && !this.isCallStmt((Stmt)u)).collect(Collectors.toSet());
    }

    public Collection<Stmt> getReturnSitesOfCallAt(Stmt u) {
        return this.getSuccsOf(u);
    }

    public Set<Stmt> getCallsFromWithin(SootMethod m) {
        return (Set)this.methodToCallsFromWithin.getUnchecked((Object)m);
    }

    public void initializeStmtToOwner(SootMethod m) {
        if (!m.hasBody()) {
            return;
        }
        Body b = m.getBody();
        b.getStmtGraph().getNodes().forEach(node -> this.stmtToOwner.put((Stmt)node, b));
    }

    @Override
    public List<Stmt> getPredsOf(Stmt u) {
        assert (u != null);
        Body body = this.getBodyOf(u);
        if (body == null) {
            return Collections.emptyList();
        }
        StmtGraph<?> stmtGraph = this.getOrCreateStmtGraph(body);
        return stmtGraph.predecessors(u);
    }

    @Override
    public Collection<Stmt> getEndPointsOf(SootMethod m) {
        if (!m.hasBody()) {
            return Collections.emptySet();
        }
        Body body = m.getBody();
        StmtGraph<?> stmtGraph = this.getOrCreateStmtGraph(body);
        return stmtGraph.getTails();
    }

    @Override
    public List<Stmt> getPredsOfCallAt(Stmt u) {
        return this.getPredsOf(u);
    }

    @Override
    public boolean isReturnSite(Stmt n) {
        return this.getPredsOf(n).stream().anyMatch(this::isCallStmt);
    }

    @Override
    public boolean isReachable(Stmt u) {
        return this.stmtToOwner.containsKey(u);
    }
}

