/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.interprocedural.icfg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import sootup.callgraph.CallGraph;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.Type;
import sootup.core.types.VoidType;
import sootup.core.util.DotExporter;
import sootup.core.views.View;

public class ICFGDotExporter {
    public static String buildICFGGraph(Map<MethodSignature, StmtGraph<?>> signatureToStmtGraph, View view, CallGraph callGraph) {
        StringBuilder sb = new StringBuilder();
        DotExporter.buildDiGraphObject((StringBuilder)sb);
        Map<Integer, MethodSignature> calls = ICFGDotExporter.computeCalls(signatureToStmtGraph, view, callGraph);
        for (Map.Entry<MethodSignature, StmtGraph<?>> entry : signatureToStmtGraph.entrySet()) {
            String graph = DotExporter.buildGraph(entry.getValue(), (boolean)true, calls, (MethodSignature)entry.getKey());
            sb.append(graph).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<Integer, MethodSignature> computeCalls(Map<MethodSignature, StmtGraph<?>> stmtGraphSet, View view, CallGraph callgraph) {
        HashMap<Integer, MethodSignature> calls = new HashMap<Integer, MethodSignature>();
        for (Map.Entry<MethodSignature, StmtGraph<?>> entry : stmtGraphSet.entrySet()) {
            Collection blocks;
            StmtGraph<?> stmtGraph = entry.getValue();
            MethodSignature source = entry.getKey();
            try {
                blocks = stmtGraph.getBlocksSorted();
            }
            catch (Exception e) {
                blocks = stmtGraph.getBlocks();
            }
            for (BasicBlock block : blocks) {
                List stmts = block.getStmts();
                for (Stmt stmt : stmts) {
                    if (stmt.isInvokableStmt() && stmt.asInvokableStmt().containsInvokeExpr()) {
                        MethodSignature target = ((AbstractInvokeExpr)stmt.asInvokableStmt().getInvokeExpr().get()).getMethodSignature();
                        int hashCode = stmt.hashCode();
                        calls.put(hashCode, target);
                        ICFGDotExporter.connectEdgesToSubClasses(source, target, view, calls, callgraph);
                        continue;
                    }
                    if (!(stmt instanceof JAssignStmt)) continue;
                    JAssignStmt jAssignStmt = (JAssignStmt)stmt;
                    Integer currentHashCode = stmt.hashCode();
                    if (!(jAssignStmt.getRightOp() instanceof JNewExpr)) continue;
                    for (MethodSignature methodSignature : stmtGraphSet.keySet()) {
                        SootMethod clintMethod = view.getMethod(view.getIdentifierFactory().getStaticInitializerSignature(methodSignature.getDeclClassType())).orElse(null);
                        if (clintMethod == null) continue;
                        if (!calls.containsKey(stmt.hashCode())) {
                            calls.put(stmt.hashCode(), methodSignature);
                            continue;
                        }
                        MethodSignature secondInitMethodSignature = (MethodSignature)calls.get(currentHashCode);
                        currentHashCode = stmtGraphSet.get(secondInitMethodSignature).getStartingStmt().hashCode();
                        calls.put(currentHashCode, methodSignature);
                    }
                }
            }
        }
        return calls;
    }

    public static Set<MethodSignature> getMethodSignatureInSubClass(MethodSignature source, MethodSignature target, CallGraph callGraph) {
        if (!callGraph.containsMethod(source) || !callGraph.containsMethod(target)) {
            return Collections.emptySet();
        }
        return callGraph.callTargetsFrom(source).stream().filter(methodSignature -> !methodSignature.equals((Object)target) && ((MethodSubSignature)methodSignature.getSubSignature()).equals((Object)target.getSubSignature())).collect(Collectors.toSet());
    }

    public static void connectEdgesToSubClasses(MethodSignature source, MethodSignature target, View view, Map<Integer, MethodSignature> calls, CallGraph callgraph) {
        Set<MethodSignature> methodSignatureInSubClass = ICFGDotExporter.getMethodSignatureInSubClass(source, target, callgraph);
        methodSignatureInSubClass.forEach(subclassmethodSignature -> {
            Optional method = view.getMethod(target);
            MethodSignature initMethod = new MethodSignature(subclassmethodSignature.getDeclClassType(), new MethodSubSignature("<init>", Collections.emptyList(), (Type)VoidType.getInstance()));
            if (method.isPresent() && !subclassmethodSignature.toString().equals(initMethod.toString()) && ((SootMethod)method.get()).hasBody()) {
                calls.put(((SootMethod)method.get()).getBody().getStmtGraph().getStartingStmt().hashCode(), (MethodSignature)subclassmethodSignature);
            }
        });
    }
}

