/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.interprocedural.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.ThreadSafe;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.analysis.interprocedural.icfg.AbstractJimpleBasedICFG;
import sootup.analysis.interprocedural.icfg.ICFGDotExporter;
import sootup.callgraph.CallGraph;
import sootup.callgraph.ClassHierarchyAnalysisAlgorithm;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.views.View;

@ThreadSafe
public class JimpleBasedInterproceduralCFG
extends AbstractJimpleBasedICFG {
    protected static final Logger logger = LoggerFactory.getLogger(JimpleBasedInterproceduralCFG.class);
    protected boolean includeReflectiveCalls;
    @DontSynchronize(value="readonly")
    protected final CallGraph cg;
    protected CacheLoader<Stmt, Collection<SootMethod>> loaderUnitToCallees = new CacheLoader<Stmt, Collection<SootMethod>>(){

        @Nonnull
        public Collection<SootMethod> load(Stmt stmt) {
            ArrayList<SootMethod> res = new ArrayList<SootMethod>();
            if (!stmt.isInvokableStmt() && !stmt.asInvokableStmt().containsInvokeExpr()) {
                return res;
            }
            MethodSignature methodSignature = ((AbstractInvokeExpr)stmt.asInvokableStmt().getInvokeExpr().get()).getMethodSignature();
            Optional smOpt = JimpleBasedInterproceduralCFG.this.view.getMethod(methodSignature);
            if (smOpt.isPresent()) {
                SootMethod sm = (SootMethod)smOpt.get();
                if (sm.hasBody()) {
                    res.add(sm);
                } else {
                    logger.error("Method {} is referenced but has no body!", (Object)sm.getSignature(), (Object)new Exception());
                }
            }
            res.trimToSize();
            return res;
        }
    };
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Stmt, Collection<SootMethod>> stmtToCallees = IDESolver.DEFAULT_CACHE_BUILDER.build(this.loaderUnitToCallees);
    protected CacheLoader<SootMethod, Collection<Stmt>> loaderMethodToCallers = new CacheLoader<SootMethod, Collection<Stmt>>(){

        @Nonnull
        public Collection<Stmt> load(SootMethod method) {
            Set calls = JimpleBasedInterproceduralCFG.this.cg.callsTo((MethodSignature)method.getSignature());
            Set<Stmt> callerStmts = calls.stream().map(c -> c.getInvokableStmt()).collect(Collectors.toSet());
            return callerStmts;
        }
    };
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<SootMethod, Collection<Stmt>> methodToCallers = IDESolver.DEFAULT_CACHE_BUILDER.build(this.loaderMethodToCallers);

    public JimpleBasedInterproceduralCFG(View view, List<MethodSignature> cgEntryPoints, boolean enableExceptions, boolean includeReflectiveCalls) {
        this(new ClassHierarchyAnalysisAlgorithm(view).initialize(cgEntryPoints), view, enableExceptions, includeReflectiveCalls);
    }

    public JimpleBasedInterproceduralCFG(CallGraph cg, View view, boolean enableExceptions, boolean includeReflectiveCalls) {
        super(enableExceptions);
        this.includeReflectiveCalls = includeReflectiveCalls;
        this.view = view;
        this.cg = cg;
        this.initializeStmtToOwner();
    }

    public CallGraph getCg() {
        return this.cg;
    }

    public String buildICFGGraph(CallGraph callGraph) {
        LinkedHashMap signatureToStmtGraph = new LinkedHashMap();
        this.computeAllCalls(callGraph.getEntryMethods(), signatureToStmtGraph, callGraph);
        return ICFGDotExporter.buildICFGGraph(signatureToStmtGraph, this.view, callGraph);
    }

    public void computeAllCalls(List<MethodSignature> entryPoints, Map<MethodSignature, StmtGraph<?>> signatureToStmtGraph, CallGraph callGraph) {
        ArrayList<MethodSignature> visitedMethods = new ArrayList<MethodSignature>();
        this.computeAllCalls(entryPoints, signatureToStmtGraph, callGraph, visitedMethods);
    }

    private void computeAllCalls(List<MethodSignature> entryPoints, Map<MethodSignature, StmtGraph<?>> signatureToStmtGraph, CallGraph callGraph, List<MethodSignature> visitedMethods) {
        visitedMethods.addAll(entryPoints);
        for (MethodSignature methodSignature : entryPoints) {
            SootMethod sootMethod;
            Optional methodOpt = this.view.getMethod(methodSignature);
            if (signatureToStmtGraph.containsKey(methodSignature)) {
                return;
            }
            if (methodOpt.isPresent() && (sootMethod = (SootMethod)methodOpt.get()).hasBody()) {
                StmtGraph stmtGraph = sootMethod.getBody().getStmtGraph();
                signatureToStmtGraph.put(methodSignature, stmtGraph);
            }
            callGraph.callTargetsFrom(methodSignature).stream().filter(methodSignature1 -> !visitedMethods.contains(methodSignature1)).forEach(nextMethodSignature -> this.computeAllCalls(Collections.singletonList(nextMethodSignature), signatureToStmtGraph, callGraph, visitedMethods));
        }
    }

    protected void initializeStmtToOwner() {
        for (MethodSignature methodSignature : this.cg.getMethodSignatures()) {
            Optional methodOpt = this.view.getMethod(methodSignature);
            methodOpt.ifPresent(this::initializeStmtToOwner);
        }
    }

    public Collection<SootMethod> getCalleesOfCallAt(@Nonnull Stmt u) {
        return (Collection)this.stmtToCallees.getUnchecked((Object)u);
    }

    public Collection<Stmt> getCallersOf(@Nonnull SootMethod m) {
        return (Collection)this.methodToCallers.getUnchecked((Object)m);
    }
}

