/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.intraprocedural;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Local;

public class Fact<S> {
    @Nonnull
    private final Set<Local> aliases;
    @Nonnull
    private S state;

    public Fact(@Nonnull S initialState) {
        this(new HashSet<Local>(), initialState);
    }

    public Fact(@Nonnull Fact<S> originFact) {
        this(new HashSet<Local>(originFact.aliases), originFact.state);
    }

    protected Fact(@Nonnull Set<Local> aliases, @Nonnull S initialState) {
        this.aliases = aliases;
        this.state = initialState;
    }

    public void updateState(@Nonnull S state) {
        this.state = state;
    }

    public void addAlias(@Nonnull Local alias) {
        this.aliases.add(alias);
    }

    public boolean containsAlias(@Nonnull Local value) {
        return this.aliases.contains(value);
    }

    @Nonnull
    public S getState() {
        return this.state;
    }

    public String toString() {
        return "(" + this.aliases + ", " + this.state + ")";
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fact other = (Fact)obj;
        if (!this.aliases.equals(other.aliases)) {
            return false;
        }
        return this.state == other.state;
    }
}

