/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.intraprocedural;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.annotation.Nonnull;
import sootup.analysis.intraprocedural.AbstractFlowAnalysis;
import sootup.analysis.intraprocedural.UniverseSortedPriorityQueue;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.Stmt;

public abstract class FlowAnalysis<A>
extends AbstractFlowAnalysis<A> {
    @Nonnull
    protected final Map<Stmt, A> stmtToAfterFlow;
    @Nonnull
    protected Map<Stmt, A> filterStmtToAfterFlow;

    public FlowAnalysis(@Nonnull StmtGraph<? extends BasicBlock<?>> graph) {
        super(graph);
        this.stmtToAfterFlow = new IdentityHashMap<Stmt, A>(graph.getNodes().size() * 2 + 1);
        this.filterStmtToAfterFlow = Collections.emptyMap();
    }

    protected abstract void flowThrough(@Nonnull A var1, Stmt var2, @Nonnull A var3);

    public A getFlowAfter(@Nonnull Stmt s) {
        A a = this.stmtToAfterFlow.get(s);
        return (A)(a == null ? this.newInitialFlow() : a);
    }

    @Override
    @Nonnull
    public A getFlowBefore(@Nonnull Stmt s) {
        Object a = this.stmtToBeforeFlow.get(s);
        return (A)(a == null ? this.newInitialFlow() : a);
    }

    private void initFlow(@Nonnull Iterable<Entry<A>> universe, @Nonnull Map<Stmt, A> in, @Nonnull Map<Stmt, A> out) {
        for (Entry<A> n : universe) {
            boolean omit = true;
            if (n.in.length > 1) {
                n.inFlow = this.newInitialFlow();
                omit = !n.isRealStronglyConnected;
            } else {
                assert (n.in.length == 1) : "missing superhead";
                n.inFlow = this.getFlow(n.in[0], n);
                assert (n.inFlow != null) : "topological order is broken";
            }
            n.outFlow = omit && this.omissible(n.data) ? n.inFlow : this.newInitialFlow();
            in.put(n.data, n.inFlow);
            out.put(n.data, n.outFlow);
        }
    }

    protected boolean omissible(@Nonnull Stmt stmt) {
        return false;
    }

    protected Flow getFlow(@Nonnull Stmt from, @Nonnull Stmt mergeNode) {
        return Flow.OUT;
    }

    private A getFlow(@Nonnull Entry<A> o, @Nonnull Entry<A> e) {
        return (A)(o.inFlow == o.outFlow ? o.outFlow : this.getFlow(o.data, e.data).getFlow(o));
    }

    private void meetFlows(@Nonnull Entry<A> entry) {
        assert (entry.in.length >= 1);
        if (entry.in.length > 1) {
            boolean copy = true;
            for (Entry o : entry.in) {
                Object flow = this.getFlow(o, entry);
                if (copy) {
                    copy = false;
                    this.copy(flow, entry.inFlow);
                    continue;
                }
                this.mergeInto(entry.data, entry.inFlow, flow);
            }
        }
    }

    final int execute(@Nonnull Map<Stmt, A> inFlow, @Nonnull Map<Stmt, A> outFlow) {
        boolean isForward = this.isForward();
        List<Entry<A>> universe = Orderer.newUniverse(this.graph, isForward ? AnalysisDirection.FORWARD : AnalysisDirection.BACKWARD, this.entryInitialFlow());
        this.initFlow(universe, inFlow, outFlow);
        UniverseSortedPriorityQueue<Entry<A>> q = UniverseSortedPriorityQueue.of(universe);
        int numComputations = 0;
        Entry e;
        while ((e = (Entry)q.poll()) != null) {
            this.meetFlows(e);
            boolean hasChanged = this.flowThrough(e);
            if (hasChanged) {
                q.addAll(Arrays.asList(e.out));
            }
            ++numComputations;
        }
        return numComputations;
    }

    private boolean flowThrough(Entry<A> d) {
        if (d.inFlow == d.outFlow) {
            assert (!d.isRealStronglyConnected || d.in.length == 1);
            return true;
        }
        if (d.isRealStronglyConnected) {
            Object out = this.newInitialFlow();
            this.flowThrough(d.inFlow, d.data, out);
            if (out.equals(d.outFlow)) {
                return false;
            }
            this.copy(out, d.outFlow);
            return true;
        }
        this.flowThrough(d.inFlow, d.data, d.outFlow);
        return true;
    }

    static class Entry<F> {
        final Stmt data;
        int number;
        boolean isRealStronglyConnected;
        Entry<F>[] in;
        Entry<F>[] out;
        F inFlow;
        F outFlow;

        Entry(Stmt u, Entry<F> pred) {
            this.in = new Entry[]{pred};
            this.data = u;
            this.number = Integer.MIN_VALUE;
            this.isRealStronglyConnected = false;
        }

        public String toString() {
            return this.data == null ? "" : this.data.toString();
        }
    }

    public static enum Flow {
        IN{

            @Override
            <F> F getFlow(Entry<F> e) {
                return e.inFlow;
            }
        }
        ,
        OUT{

            @Override
            <F> F getFlow(Entry<F> e) {
                return e.outFlow;
            }
        };


        abstract <F> F getFlow(Entry<F> var1);
    }

    static enum AnalysisDirection {
        BACKWARD{

            @Override
            @Nonnull
            List<Stmt> getEntries(StmtGraph<? extends BasicBlock<?>> g) {
                return g.getTails();
            }

            @Override
            @Nonnull
            List<Stmt> getOut(StmtGraph<? extends BasicBlock<?>> g, Stmt s) {
                return g.predecessors(s);
            }
        }
        ,
        FORWARD{

            @Override
            @Nonnull
            List<Stmt> getEntries(StmtGraph<? extends BasicBlock<?>> g) {
                return (List)g.getEntrypoints();
            }

            @Override
            @Nonnull
            List<Stmt> getOut(StmtGraph<? extends BasicBlock<?>> g, Stmt s) {
                return g.successors(s);
            }
        };


        @Nonnull
        abstract List<Stmt> getEntries(StmtGraph<? extends BasicBlock<?>> var1);

        @Nonnull
        abstract List<Stmt> getOut(StmtGraph<? extends BasicBlock<?>> var1, Stmt var2);
    }

    static class Orderer {
        Orderer() {
        }

        static <F> List<Entry<F>> newUniverse(@Nonnull StmtGraph<? extends BasicBlock<?>> g, @Nonnull AnalysisDirection direction, @Nonnull F entryFlow) {
            List<Stmt> entries;
            int size;
            int n = size = g.getNodes().size();
            ArrayDeque<Entry<F>> s = new ArrayDeque<Entry<F>>(n);
            ArrayList<Entry<F>> universe = new ArrayList<Entry<F>>(n);
            HashMap<Stmt, Entry<F>> visited = new HashMap<Stmt, Entry<F>>((n + 1) * 4 / 3);
            Entry superEntry = new Entry(null, null);
            List<Stmt> actualEntries = direction.getEntries(g);
            if (!actualEntries.isEmpty()) {
                entries = actualEntries;
            } else {
                if (AnalysisDirection.FORWARD == direction) {
                    throw new RuntimeException("error: no entry point for method in forward analysis");
                }
                entries = new ArrayList<Stmt>();
                Collection entrypoints = g.getEntrypoints();
                assert (entrypoints.size() == 1);
                Stmt head = (Stmt)entrypoints.iterator().next();
                HashSet<Stmt> visitedNodes = new HashSet<Stmt>();
                ArrayList<Stmt> workList = new ArrayList<Stmt>();
                workList.add(head);
                while (!workList.isEmpty()) {
                    Stmt currentStmt = (Stmt)workList.remove(0);
                    visitedNodes.add(currentStmt);
                    if (currentStmt instanceof JGotoStmt) {
                        entries.add(currentStmt);
                    }
                    for (Stmt successor : g.successors(currentStmt)) {
                        if (visitedNodes.contains(successor)) continue;
                        workList.add(successor);
                    }
                }
                if (entries.isEmpty()) {
                    throw new RuntimeException("error: backward analysis on an empty entry set.");
                }
            }
            Orderer.visitEntry(visited, superEntry, entries);
            superEntry.inFlow = entryFlow;
            superEntry.outFlow = entryFlow;
            Entry[] sv = new Entry[size];
            int[] si = new int[size];
            int index = 0;
            int i = 0;
            Entry v = superEntry;
            while (true) {
                if (i < v.out.length) {
                    Entry w = v.out[i++];
                    if (w.number != Integer.MIN_VALUE) continue;
                    w.number = s.size();
                    s.add(w);
                    Orderer.visitEntry(visited, w, direction.getOut(g, w.data));
                    si[index] = i;
                    sv[index] = v;
                    ++index;
                    i = 0;
                    v = w;
                    continue;
                }
                if (index == 0) {
                    assert (universe.size() <= size);
                    Collections.reverse(universe);
                    return universe;
                }
                universe.add(v);
                Orderer.sccPop(s, v);
                v = sv[--index];
                i = si[index];
            }
        }

        @Nonnull
        private static <D, F> Entry<F>[] visitEntry(Map<Stmt, Entry<F>> visited, Entry<F> v, List<Stmt> out) {
            int n = out.size();
            Entry[] a = new Entry[n];
            assert (out instanceof RandomAccess);
            for (int i = 0; i < n; ++i) {
                a[i] = Orderer.getEntryOf(visited, out.get(i), v);
            }
            v.out = a;
            return a;
        }

        @Nonnull
        private static <F> Entry<F> getEntryOf(@Nonnull Map<Stmt, Entry<F>> visited, @Nonnull Stmt stmt, @Nonnull Entry<F> v) {
            Entry<F> newEntry = new Entry<F>(stmt, v);
            Entry<F> oldEntry = visited.putIfAbsent(stmt, newEntry);
            if (oldEntry == null) {
                return newEntry;
            }
            if (oldEntry == v) {
                oldEntry.isRealStronglyConnected = true;
            }
            int l = oldEntry.in.length;
            oldEntry.in = Arrays.copyOf(oldEntry.in, l + 1);
            oldEntry.in[l] = v;
            return oldEntry;
        }

        private static <D, F> void sccPop(@Nonnull Deque<Entry<F>> s, @Nonnull Entry<F> v) {
            int min = v.number;
            for (Entry e : v.out) {
                assert (e.number > Integer.MIN_VALUE);
                min = Math.min(min, e.number);
            }
            if (min != v.number) {
                v.number = min;
                return;
            }
            Entry<F> w = s.removeLast();
            w.number = Integer.MAX_VALUE;
            if (w == v) {
                return;
            }
            w.isRealStronglyConnected = true;
            do {
                w = s.removeLast();
                assert (w.number >= v.number);
                w.isRealStronglyConnected = true;
                w.number = Integer.MAX_VALUE;
            } while (w != v);
            assert (w.in.length >= 2);
        }
    }
}

