/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.intraprocedural;

import java.util.AbstractQueue;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UniverseSortedPriorityQueue<E>
extends AbstractQueue<E> {
    private static final Logger logger = LoggerFactory.getLogger(UniverseSortedPriorityQueue.class);
    protected final List<? extends E> universe;
    protected final Map<E, Integer> ordinalMap;
    int min = Integer.MAX_VALUE;

    UniverseSortedPriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
        assert (ordinalMap.size() == universe.size());
        this.universe = universe;
        this.ordinalMap = ordinalMap;
    }

    int getOrdinal(@Nonnull Object o) {
        Integer i = this.ordinalMap.get(o);
        if (i == null) {
            throw new NoSuchElementException();
        }
        return i;
    }

    abstract void addAll();

    abstract int nextSetBit(int var1);

    abstract boolean remove(int var1);

    @Override
    abstract boolean add(int var1);

    abstract boolean contains(int var1);

    @Override
    public final E peek() {
        return this.isEmpty() ? null : (E)this.universe.get(this.min);
    }

    @Override
    public final E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E e = this.universe.get(this.min);
        this.remove(this.min);
        return e;
    }

    @Override
    public final boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public final boolean offer(E e) {
        return this.add(this.getOrdinal(e));
    }

    @Override
    public final boolean remove(Object o) {
        if (o == null || this.isEmpty()) {
            return false;
        }
        try {
            if (o == this.peek()) {
                this.remove(this.min);
                return true;
            }
            return this.remove(this.getOrdinal(o));
        }
        catch (NoSuchElementException e) {
            logger.debug(e.getMessage());
            return false;
        }
    }

    @Override
    public final boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        try {
            if (o == this.peek()) {
                return true;
            }
            return this.contains(this.getOrdinal(o));
        }
        catch (NoSuchElementException e) {
            logger.debug(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.min >= this.universe.size();
    }

    public static <E> UniverseSortedPriorityQueue<E> of(List<? extends E> universe) {
        UniverseSortedPriorityQueue<E> q = UniverseSortedPriorityQueue.noneOf(universe);
        q.addAll();
        return q;
    }

    public static <E> UniverseSortedPriorityQueue<E> noneOf(List<? extends E> universe) {
        HashMap<E, Integer> ordinalMap = new HashMap<E, Integer>(2 * universe.size() / 3);
        int i = 0;
        for (E e : universe) {
            if (e == null) {
                throw new IllegalArgumentException("null is not allowed");
            }
            if (ordinalMap.put(e, i++) == null) continue;
            throw new IllegalArgumentException("duplicate key found");
        }
        return UniverseSortedPriorityQueue.newPriorityQueue(universe, ordinalMap);
    }

    private static <E> UniverseSortedPriorityQueue<E> newPriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
        return new LargeUniverseSortedPriorityQueue<E>(universe, ordinalMap);
    }

    static class LargeUniverseSortedPriorityQueue<E>
    extends UniverseSortedPriorityQueue<E> {
        private final BitSet queue;
        private long modCount = 0L;

        LargeUniverseSortedPriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
            super(universe, ordinalMap);
            this.queue = new BitSet(universe.size());
        }

        @Override
        boolean add(int ordinal) {
            if (this.contains(ordinal)) {
                return false;
            }
            this.queue.set(ordinal);
            this.min = Math.min(this.min, ordinal);
            ++this.modCount;
            return true;
        }

        @Override
        void addAll() {
            this.queue.set(0, this.universe.size());
            this.min = 0;
            ++this.modCount;
        }

        @Override
        int nextSetBit(int fromIndex) {
            int i = this.queue.nextSetBit(fromIndex);
            return i < 0 ? Integer.MAX_VALUE : i;
        }

        @Override
        boolean remove(int ordinal) {
            if (!this.contains(ordinal)) {
                return false;
            }
            this.queue.clear(ordinal);
            if (this.min == ordinal) {
                this.min = this.nextSetBit(this.min + 1);
            }
            ++this.modCount;
            return true;
        }

        @Override
        boolean contains(int ordinal) {
            return this.queue.get(ordinal);
        }

        @Override
        @Nonnull
        public Iterator<E> iterator() {
            return new Itr(){

                @Override
                long getExpected() {
                    return modCount;
                }
            };
        }

        @Override
        public int size() {
            return this.queue.cardinality();
        }
    }

    abstract class Itr
    implements Iterator<E> {
        long expected = this.getExpected();
        int next;
        int now;

        Itr() {
            this.next = UniverseSortedPriorityQueue.this.min;
            this.now = Integer.MAX_VALUE;
        }

        abstract long getExpected();

        @Override
        public boolean hasNext() {
            return this.next < UniverseSortedPriorityQueue.this.universe.size();
        }

        @Override
        public E next() {
            if (this.expected != this.getExpected()) {
                throw new ConcurrentModificationException();
            }
            if (this.next >= UniverseSortedPriorityQueue.this.universe.size()) {
                throw new NoSuchElementException();
            }
            this.now = this.next;
            this.next = UniverseSortedPriorityQueue.this.nextSetBit(this.next + 1);
            return UniverseSortedPriorityQueue.this.universe.get(this.now);
        }

        @Override
        public void remove() {
            if (this.now >= UniverseSortedPriorityQueue.this.universe.size()) {
                throw new IllegalStateException();
            }
            if (this.expected != this.getExpected()) {
                throw new ConcurrentModificationException();
            }
            UniverseSortedPriorityQueue.this.remove(this.now);
            this.expected = this.getExpected();
            this.now = Integer.MAX_VALUE;
        }
    }
}

