/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.interprocedural.icfg;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import sootup.analysis.interprocedural.icfg.CalleeMethodSignature;
import sootup.callgraph.CallGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.views.View;

public class CGEdgeUtil {
    public static CallGraphEdgeType findCallGraphEdgeType(AbstractInvokeExpr invokeExpr) {
        if (invokeExpr instanceof JVirtualInvokeExpr) {
            return CallGraphEdgeType.VIRTUAL;
        }
        if (invokeExpr instanceof JSpecialInvokeExpr) {
            return CallGraphEdgeType.SPECIAL;
        }
        if (invokeExpr instanceof JInterfaceInvokeExpr) {
            return CallGraphEdgeType.INTERFACE;
        }
        if (invokeExpr instanceof JStaticInvokeExpr) {
            return CallGraphEdgeType.STATIC;
        }
        if (invokeExpr instanceof JDynamicInvokeExpr) {
            return CallGraphEdgeType.DYNAMIC;
        }
        throw new RuntimeException("No such invokeExpr:" + invokeExpr);
    }

    public static Set<Pair<MethodSignature, CalleeMethodSignature>> getCallEdges(View view, CallGraph cg) {
        Set methodSigs = cg.getMethodSignatures();
        HashSet<Pair<MethodSignature, CalleeMethodSignature>> callEdges = new HashSet<Pair<MethodSignature, CalleeMethodSignature>>();
        for (MethodSignature caller : methodSigs) {
            SootMethod method = view.getMethod(caller).orElse(null);
            if (method == null || !method.hasBody()) continue;
            for (Stmt s : method.getBody().getStmtGraph().getNodes()) {
                if (!s.containsInvokeExpr()) continue;
                CalleeMethodSignature callee = new CalleeMethodSignature(s.getInvokeExpr().getMethodSignature(), CGEdgeUtil.findCallGraphEdgeType(s.getInvokeExpr()), s);
                callEdges.add((Pair<MethodSignature, CalleeMethodSignature>)new ImmutablePair((Object)caller, (Object)callee));
            }
        }
        return callEdges;
    }

    public static enum CallGraphEdgeType {
        INVALID("INVALID"),
        STATIC("STATIC"),
        VIRTUAL("VIRTUAL"),
        INTERFACE("INTERFACE"),
        SPECIAL("SPECIAL"),
        DYNAMIC("DYNAMIC"),
        CLINIT("CLINIT"),
        GENERIC_FAKE("GENERIC_FAKE"),
        THREAD("THREAD"),
        EXECUTOR("EXECUTOR"),
        ASYNCTASK("ASYNCTASK"),
        FINALIZE("FINALIZE"),
        HANDLER("HANDLER"),
        INVOKE_FINALIZE("INVOKE_FINALIZE"),
        PRIVILEGED("PRIVILEGED"),
        NEWINSTANCE("NEWINSTANCE"),
        REFL_INVOKE("REFL_INVOKE"),
        REFL_CONSTR_NEWINSTANCE("REFL_CONSTR_NEWINSTANCE"),
        REFL_CLASS_NEWINSTANCE("REFL_CLASS_NEWINSTANCE");

        private String name;

        private CallGraphEdgeType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        public boolean passesParameters() {
            return this.isExplicit() || this == THREAD || this == EXECUTOR || this == ASYNCTASK || this == FINALIZE || this == PRIVILEGED || this == NEWINSTANCE || this == INVOKE_FINALIZE || this == REFL_INVOKE || this == REFL_CONSTR_NEWINSTANCE || this == REFL_CLASS_NEWINSTANCE;
        }

        public boolean isFake() {
            return this == THREAD || this == EXECUTOR || this == ASYNCTASK || this == PRIVILEGED || this == HANDLER || this == GENERIC_FAKE;
        }

        public boolean isExplicit() {
            return this.isInstance() || this.isStatic();
        }

        public boolean isInstance() {
            return this == VIRTUAL || this == INTERFACE || this == SPECIAL;
        }

        public boolean isVirtual() {
            return this == VIRTUAL;
        }

        public boolean isSpecial() {
            return this == SPECIAL;
        }

        public boolean isClinit() {
            return this == CLINIT;
        }

        public boolean isStatic() {
            return this == STATIC;
        }

        public boolean isDynamic() {
            return this == DYNAMIC;
        }

        public boolean isThread() {
            return this == THREAD;
        }

        public boolean isExecutor() {
            return this == EXECUTOR;
        }

        public boolean isAsyncTask() {
            return this == ASYNCTASK;
        }

        public boolean isPrivileged() {
            return this == PRIVILEGED;
        }

        public boolean isReflection() {
            return this == REFL_CLASS_NEWINSTANCE || this == REFL_CONSTR_NEWINSTANCE || this == REFL_INVOKE;
        }

        public boolean isReflInvoke() {
            return this == REFL_INVOKE;
        }
    }
}

