/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.callgraph.CallGraph;
import sootup.callgraph.CallGraphAlgorithm;
import sootup.callgraph.GraphBasedCallGraph;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Method;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.types.JavaClassType;

public abstract class AbstractCallGraphAlgorithm
implements CallGraphAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCallGraphAlgorithm.class);
    @Nonnull
    protected final View<? extends SootClass<?>> view;
    @Nonnull
    protected final TypeHierarchy typeHierarchy;

    protected AbstractCallGraphAlgorithm(@Nonnull View<? extends SootClass<?>> view, @Nonnull TypeHierarchy typeHierarchy) {
        this.view = view;
        this.typeHierarchy = typeHierarchy;
    }

    @Nonnull
    final CallGraph constructCompleteCallGraph(View<? extends SootClass<?>> view, List<MethodSignature> entryPoints) {
        GraphBasedCallGraph cg = new GraphBasedCallGraph();
        ArrayDeque<MethodSignature> workList = new ArrayDeque<MethodSignature>(entryPoints);
        HashSet<MethodSignature> processed = new HashSet<MethodSignature>();
        this.processWorkList(view, workList, processed, cg);
        return cg;
    }

    final void processWorkList(View<? extends SootClass<?>> view, Deque<MethodSignature> workList, Set<MethodSignature> processed, MutableCallGraph cg) {
        while (!workList.isEmpty()) {
            MethodSignature currentMethodSignature = workList.pop();
            if (processed.contains(currentMethodSignature)) continue;
            if (!cg.containsMethod(currentMethodSignature)) {
                cg.addMethod(currentMethodSignature);
            }
            Stream<MethodSignature> invocationTargets = this.resolveAllCallsFromSourceMethod(view, currentMethodSignature);
            invocationTargets.forEach(t -> {
                if (!cg.containsMethod((MethodSignature)t)) {
                    cg.addMethod((MethodSignature)t);
                }
                if (!cg.containsCall(currentMethodSignature, (MethodSignature)t)) {
                    cg.addCall(currentMethodSignature, (MethodSignature)t);
                    workList.push((MethodSignature)t);
                }
            });
            processed.add(currentMethodSignature);
            this.postProcessingMethod(view, currentMethodSignature, workList, cg);
        }
    }

    @Nonnull
    Stream<MethodSignature> resolveAllCallsFromSourceMethod(View<? extends SootClass<?>> view, MethodSignature sourceMethod) {
        SootMethod currentMethodCandidate = view.getClass(sourceMethod.getDeclClassType()).flatMap(c -> c.getMethod((MethodSubSignature)sourceMethod.getSubSignature())).orElse(null);
        if (currentMethodCandidate == null) {
            return Stream.empty();
        }
        if (currentMethodCandidate.hasBody()) {
            return currentMethodCandidate.getBody().getStmtGraph().nodes().stream().filter(Stmt::containsInvokeExpr).flatMap(s2 -> this.resolveCall(currentMethodCandidate, s2.getInvokeExpr()));
        }
        return Stream.empty();
    }

    final <T extends Method> T findMethodInHierarchy(@Nonnull View<? extends SootClass<?>> view, @Nonnull MethodSignature sig) {
        Optional<SootClass<?>> optSc = view.getClass(sig.getDeclClassType());
        if (optSc.isPresent()) {
            SootClass<?> sc = optSc.get();
            List<ClassType> superClasses = this.typeHierarchy.superClassesOf(sc.getType());
            Set<ClassType> interfaces = this.typeHierarchy.implementedInterfacesOf(sc.getType());
            superClasses.addAll(interfaces);
            for (ClassType superClassType : superClasses) {
                SootClass<?> superClass;
                Optional<SootMethod> methodOpt;
                Optional<SootClass<?>> superClassOpt = view.getClass(superClassType);
                if (!superClassOpt.isPresent() || !(methodOpt = (superClass = superClassOpt.get()).getMethod((MethodSubSignature)sig.getSubSignature())).isPresent()) continue;
                return (T)methodOpt.get();
            }
            logger.warn("Could not find \"" + sig.getSubSignature() + "\" in " + sig.getDeclClassType().getClassName() + " and in its superclasses");
        } else {
            logger.trace("Could not find \"" + sig.getDeclClassType() + "\" in view");
        }
        return null;
    }

    public void postProcessingMethod(View<? extends SootClass<?>> view, MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
    }

    @Override
    @Nonnull
    public CallGraph addClass(@Nonnull CallGraph oldCallGraph, @Nonnull JavaClassType classType) {
        MutableCallGraph updated = oldCallGraph.copy();
        SootClass<?> clazz = this.view.getClassOrThrow(classType);
        Set newMethodSignatures = clazz.getMethods().stream().map(Method::getSignature).collect(Collectors.toSet());
        if (newMethodSignatures.stream().anyMatch(oldCallGraph::containsMethod)) {
            throw new IllegalArgumentException("CallGraph already contains methods from " + classType);
        }
        ArrayDeque<MethodSignature> workList = new ArrayDeque<MethodSignature>(newMethodSignatures);
        HashSet<MethodSignature> processed = new HashSet<MethodSignature>(oldCallGraph.getMethodSignatures());
        this.processWorkList(this.view, workList, processed, updated);
        List<ClassType> superClasses = this.typeHierarchy.superClassesOf(classType);
        Set<ClassType> implementedInterfaces = this.typeHierarchy.implementedInterfacesOf(classType);
        Stream superTypes = Stream.concat(superClasses.stream(), implementedInterfaces.stream());
        Set newMethodSubSigs = newMethodSignatures.stream().map(SootClassMemberSignature::getSubSignature).collect(Collectors.toSet());
        superTypes.map(this.view::getClassOrThrow).flatMap(superType -> superType.getMethods().stream()).map(Method::getSignature).filter(superTypeMethodSig -> newMethodSubSigs.contains(superTypeMethodSig.getSubSignature())).forEach(overriddenMethodSig -> {
            MethodSignature overridingMethodSig = (MethodSignature)clazz.getMethod((MethodSubSignature)overriddenMethodSig.getSubSignature()).get().getSignature();
            for (MethodSignature callingMethodSig : updated.callsTo((MethodSignature)overriddenMethodSig)) {
                updated.addCall(callingMethodSig, overridingMethodSig);
            }
        });
        return updated;
    }

    public MethodSignature findMainMethod() {
        HashSet classes = new HashSet();
        for (SootClass<?> aClass : this.view.getClasses()) {
            if (aClass.isLibraryClass()) continue;
            classes.add(aClass);
        }
        HashSet<SootMethod> mainMethods = new HashSet<SootMethod>();
        for (SootClass sootClass : classes) {
            for (SootMethod method : sootClass.getMethods()) {
                if (!method.isStatic() || !((MethodSignature)method.getSignature()).equals(JavaIdentifierFactory.getInstance().getMethodSignature(sootClass.getType(), "main", "void", Collections.singletonList("java.lang.String[]")))) continue;
                mainMethods.add(method);
            }
        }
        if (mainMethods.size() > 1) {
            throw new RuntimeException("There are more than 1 main method present.\n Below main methods are found: \n" + mainMethods + "\n initialize() method can be used if only one main method exists. \n You can specify these main methods as entry points by passing them as parameter to initialize method.");
        }
        if (mainMethods.size() == 0) {
            throw new RuntimeException("No main method is present in the input programs. initialize() method can be used if only one main method exists in the input program and that should be used as entry point for call graph. \n Please specify entry point as a parameter to initialize method.");
        }
        return (MethodSignature)((SootMethod)mainMethods.stream().findFirst().get()).getSignature();
    }

    @Nonnull
    abstract Stream<MethodSignature> resolveCall(SootMethod var1, AbstractInvokeExpr var2);
}

