/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.callgraph.AbstractCallGraphAlgorithm;
import sootup.callgraph.CallGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.model.Modifier;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.typehierarchy.MethodDispatchResolver;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.views.View;

public class ClassHierarchyAnalysisAlgorithm
extends AbstractCallGraphAlgorithm {
    public ClassHierarchyAnalysisAlgorithm(@Nonnull View<? extends SootClass<?>> view, @Nonnull TypeHierarchy typeHierarchy) {
        super(view, typeHierarchy);
    }

    @Override
    @Nonnull
    public CallGraph initialize() {
        return this.constructCompleteCallGraph(this.view, Collections.singletonList(this.findMainMethod()));
    }

    @Override
    @Nonnull
    public CallGraph initialize(@Nonnull List<MethodSignature> entryPoints) {
        return this.constructCompleteCallGraph(this.view, entryPoints);
    }

    @Override
    @Nonnull
    protected Stream<MethodSignature> resolveCall(SootMethod method, AbstractInvokeExpr invokeExpr) {
        MethodSignature targetMethodSignature = invokeExpr.getMethodSignature();
        if (invokeExpr instanceof JDynamicInvokeExpr) {
            return Stream.empty();
        }
        Stream<MethodSignature> result = Stream.of(targetMethodSignature);
        SootMethod targetMethod = this.view.getClass(targetMethodSignature.getDeclClassType()).flatMap(clazz -> clazz.getMethod((MethodSubSignature)targetMethodSignature.getSubSignature())).orElseGet(() -> (SootMethod)this.findMethodInHierarchy(this.view, targetMethodSignature));
        if (targetMethod == null || Modifier.isStatic(targetMethod.getModifiers()) || invokeExpr instanceof JSpecialInvokeExpr) {
            return result;
        }
        return Stream.concat(result, MethodDispatchResolver.resolveAbstractDispatch(this.view, targetMethodSignature).stream());
    }
}

