/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jgrapht.graph.DefaultDirectedGraph;
import sootup.callgraph.MutableCallGraph;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.java.core.types.JavaClassType;

public final class GraphBasedCallGraph
implements MutableCallGraph {
    @Nonnull
    private final DefaultDirectedGraph<Vertex, Edge> graph;
    @Nonnull
    private final Map<MethodSignature, Vertex> signatureToVertex;
    @Nonnull
    private final Map<JavaClassType, Set<Vertex>> typeToVertices;

    GraphBasedCallGraph() {
        this.graph = new DefaultDirectedGraph(null, null, false);
        this.signatureToVertex = new HashMap<MethodSignature, Vertex>();
        this.typeToVertices = new HashMap<JavaClassType, Set<Vertex>>();
    }

    private GraphBasedCallGraph(@Nonnull DefaultDirectedGraph<Vertex, Edge> graph, @Nonnull Map<MethodSignature, Vertex> signatureToVertex, @Nonnull Map<JavaClassType, Set<Vertex>> typeToVertices) {
        this.graph = graph;
        this.signatureToVertex = signatureToVertex;
        this.typeToVertices = typeToVertices;
    }

    @Override
    public void addMethod(@Nonnull MethodSignature calledMethod) {
        Vertex v = new Vertex(calledMethod);
        this.graph.addVertex(v);
        this.signatureToVertex.put(calledMethod, v);
    }

    @Override
    public void addCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod) {
        this.graph.addEdge(this.vertexOf(sourceMethod), this.vertexOf(targetMethod), new Edge());
    }

    @Override
    @Nonnull
    public Set<MethodSignature> getMethodSignatures() {
        return this.signatureToVertex.keySet();
    }

    @Override
    @Nonnull
    public Set<MethodSignature> callsFrom(@Nonnull MethodSignature sourceMethod) {
        return this.graph.outgoingEdgesOf(this.vertexOf(sourceMethod)).stream().map(this.graph::getEdgeTarget).map(targetVertex -> targetVertex.methodSignature).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<MethodSignature> callsTo(@Nonnull MethodSignature targetMethod) {
        return this.graph.incomingEdgesOf(this.vertexOf(targetMethod)).stream().map(this.graph::getEdgeSource).map(targetVertex -> targetVertex.methodSignature).collect(Collectors.toSet());
    }

    @Override
    public boolean containsMethod(@Nonnull MethodSignature method) {
        return this.signatureToVertex.containsKey(method);
    }

    @Override
    public boolean containsCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod) {
        if (!this.containsMethod(sourceMethod) || !this.containsMethod(targetMethod)) {
            return false;
        }
        return this.graph.containsEdge(this.vertexOf(sourceMethod), this.vertexOf(targetMethod));
    }

    @Override
    public int callCount() {
        return this.graph.edgeSet().size();
    }

    @Override
    @Nonnull
    public MutableCallGraph copy() {
        return new GraphBasedCallGraph((DefaultDirectedGraph)this.graph.clone(), new HashMap<MethodSignature, Vertex>(this.signatureToVertex), new HashMap<JavaClassType, Set<Vertex>>(this.typeToVertices));
    }

    @Nonnull
    private Vertex vertexOf(@Nonnull MethodSignature method) {
        Vertex methodVertex = this.signatureToVertex.get(method);
        Preconditions.checkNotNull(methodVertex, "Node for " + method + " has not been added yet");
        return methodVertex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GraphBasedCallGraph(" + this.callCount() + ")");
        if (this.signatureToVertex.keySet().isEmpty()) {
            sb.append(" is empty");
        } else {
            sb.append(":\n");
            for (MethodSignature method : this.signatureToVertex.keySet()) {
                sb.append(method.toString()).append(":\n");
                this.callsFrom(method).forEach(m3 -> sb.append("\tto ").append(m3).append("\n"));
                this.callsTo(method).forEach(m3 -> sb.append("\tfrom   ").append(m3).append("\n"));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String toStringSorted() {
        StringBuilder stringBuilder = new StringBuilder("GraphBasedCallGraph(" + this.callCount() + ")");
        if (this.signatureToVertex.keySet().isEmpty()) {
            stringBuilder.append(" is empty");
        } else {
            stringBuilder.append(":\n");
            this.signatureToVertex.keySet().stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(method -> {
                stringBuilder.append(method).append(":\n");
                this.callsFrom((MethodSignature)method).stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(m3 -> stringBuilder.append("\tto ").append(m3).append("\n"));
                this.callsTo((MethodSignature)method).stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(m3 -> stringBuilder.append("\tfrom ").append(m3).append("\n"));
                stringBuilder.append("\n");
            });
        }
        return stringBuilder.toString();
    }

    private static class Edge {
        private Edge() {
        }
    }

    private static class Vertex {
        @Nonnull
        final MethodSignature methodSignature;

        private Vertex(@Nonnull MethodSignature methodSignature) {
            this.methodSignature = methodSignature;
        }
    }
}

