/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.callgraph.AbstractCallGraphAlgorithm;
import sootup.callgraph.CallGraph;
import sootup.callgraph.ClassHierarchyAnalysisAlgorithm;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.model.Modifier;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.typehierarchy.MethodDispatchResolver;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class RapidTypeAnalysisAlgorithm
extends AbstractCallGraphAlgorithm {
    @Nonnull
    private Set<ClassType> instantiatedClasses = new HashSet<ClassType>();
    @Nonnull
    private HashMap<ClassType, List<Call>> ignoredCalls = new HashMap();
    @Nonnull
    private CallGraph chaGraph;

    public RapidTypeAnalysisAlgorithm(@Nonnull View view, @Nonnull TypeHierarchy typeHierarchy) {
        super(view, typeHierarchy);
    }

    @Override
    @Nonnull
    public CallGraph initialize() {
        ClassHierarchyAnalysisAlgorithm cha = new ClassHierarchyAnalysisAlgorithm(this.view, this.typeHierarchy);
        List<MethodSignature> entryPoints = Collections.singletonList(this.findMainMethod());
        this.chaGraph = cha.initialize(entryPoints);
        return this.constructCompleteCallGraph(this.view, entryPoints);
    }

    @Override
    @Nonnull
    public CallGraph initialize(@Nonnull List<MethodSignature> entryPoints) {
        ClassHierarchyAnalysisAlgorithm cha = new ClassHierarchyAnalysisAlgorithm(this.view, this.typeHierarchy);
        this.chaGraph = cha.initialize(entryPoints);
        return this.constructCompleteCallGraph(this.view, entryPoints);
    }

    private void collectInstantiatedClassesInMethod(SootMethod method) {
        Set instantiated = this.chaGraph.callsFrom((MethodSignature)method.getSignature()).stream().filter(s2 -> ((MethodSubSignature)s2.getSubSignature()).getName().equals("<init>")).map(s2 -> s2.getDeclClassType()).collect(Collectors.toSet());
        this.instantiatedClasses.addAll(instantiated);
        instantiated.stream().map(s2 -> this.view.getClass((ClassType)s2)).filter(Optional::isPresent).map(Optional::get).map(s2 -> s2.getSuperclass()).filter(s2 -> s2.isPresent()).map(s2 -> (ClassType)s2.get()).forEach(this.instantiatedClasses::add);
    }

    @Override
    @Nonnull
    protected Stream<MethodSignature> resolveCall(SootMethod method, AbstractInvokeExpr invokeExpr) {
        MethodSignature targetMethodSignature = invokeExpr.getMethodSignature();
        Stream<MethodSignature> result = Stream.of(targetMethodSignature);
        if (!this.chaGraph.containsMethod((MethodSignature)method.getSignature())) {
            return result;
        }
        this.collectInstantiatedClassesInMethod(method);
        SootMethod targetMethod = this.view.getClass(targetMethodSignature.getDeclClassType()).flatMap(clazz -> clazz.getMethod((MethodSubSignature)targetMethodSignature.getSubSignature())).orElseGet(() -> (SootMethod)this.findMethodInHierarchy(this.view, targetMethodSignature));
        if (targetMethod == null || Modifier.isStatic(targetMethod.getModifiers()) || invokeExpr instanceof JSpecialInvokeExpr) {
            return result;
        }
        HashSet<MethodSignature> notInstantiatedCallTargets = Sets.newHashSet();
        Set<MethodSignature> implAndOverrides = MethodDispatchResolver.resolveAbstractDispatchInClasses(this.view, targetMethodSignature, this.instantiatedClasses, notInstantiatedCallTargets);
        notInstantiatedCallTargets.forEach(ignoredMethodSignature -> {
            List<Call> calls = this.ignoredCalls.get(ignoredMethodSignature.getDeclClassType());
            if (calls == null) {
                calls = new ArrayList<Call>();
                calls.add(new Call((MethodSignature)method.getSignature(), (MethodSignature)ignoredMethodSignature));
                this.ignoredCalls.put(ignoredMethodSignature.getDeclClassType(), calls);
            } else {
                calls.add(new Call((MethodSignature)method.getSignature(), (MethodSignature)ignoredMethodSignature));
            }
        });
        return Stream.concat(result, implAndOverrides.stream());
    }

    @Override
    public void postProcessingMethod(View<? extends SootClass<?>> view, MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
        this.instantiatedClasses.forEach(instantiatedClassType -> {
            List<Call> newEdges = this.ignoredCalls.get(instantiatedClassType);
            if (newEdges != null) {
                newEdges.forEach(call -> {
                    if (cg.containsMethod(call.target)) {
                        cg.addCall(call.source, call.target);
                    } else {
                        cg.addMethod(call.target);
                        cg.addCall(call.source, call.target);
                        workList.push(call.target);
                    }
                });
                this.ignoredCalls.remove(instantiatedClassType);
            }
        });
    }

    private static class Call {
        @Nonnull
        final MethodSignature source;
        @Nonnull
        final MethodSignature target;

        private Call(@Nonnull MethodSignature source, MethodSignature target) {
            this.source = source;
            this.target = target;
        }
    }
}

