/*
 * Decompiled with CFR 0.152.
 */
package sootup.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.Language;
import sootup.core.SourceTypeSpecifier;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.ClassLoadingOptions;
import sootup.core.model.SootClass;
import sootup.core.views.View;

public abstract class Project<S extends SootClass<?>, V extends View<? extends SootClass<?>>> {
    @Nonnull
    private final IdentifierFactory identifierFactory;
    @Nonnull
    private final List<AnalysisInputLocation<? extends S>> inputLocations;
    @Nonnull
    private final SourceTypeSpecifier sourceTypeSpecifier;
    @Nonnull
    private final Language language;

    public Project(@Nonnull Language language, @Nonnull AnalysisInputLocation<? extends S> inputLocation, @Nonnull SourceTypeSpecifier sourceTypeSpecifier) {
        this(language, Collections.singletonList(inputLocation), language.getIdentifierFactory(), sourceTypeSpecifier);
    }

    public Project(@Nonnull Language language, @Nonnull List<AnalysisInputLocation<? extends S>> inputLocations, @Nonnull IdentifierFactory identifierFactory, @Nonnull SourceTypeSpecifier sourceTypeSpecifier) {
        this.language = language;
        List<AnalysisInputLocation<S>> unmodifiableInputLocations = Collections.unmodifiableList(new ArrayList<AnalysisInputLocation<? extends S>>(inputLocations));
        this.sourceTypeSpecifier = sourceTypeSpecifier;
        this.inputLocations = unmodifiableInputLocations;
        this.identifierFactory = identifierFactory;
    }

    public void validate() {
        if (this.inputLocations.isEmpty()) {
            throw new IllegalArgumentException("The inputLocations collection must not be empty.");
        }
    }

    @Nonnull
    public List<AnalysisInputLocation<? extends S>> getInputLocations() {
        return this.inputLocations;
    }

    @Nonnull
    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    @Nonnull
    public SourceTypeSpecifier getSourceTypeSpecifier() {
        return this.sourceTypeSpecifier;
    }

    @Nonnull
    public Language getLanguage() {
        return this.language;
    }

    @Nonnull
    public abstract V createFullView();

    @Nonnull
    public abstract V createOnDemandView();

    @Nonnull
    public abstract V createOnDemandView(@Nonnull Function<AnalysisInputLocation<? extends S>, ClassLoadingOptions> var1);
}

