/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.frontend;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.BodySource;
import sootup.core.model.Body;
import sootup.core.model.Modifier;
import sootup.core.signatures.MethodSignature;

public class OverridingBodySource
implements BodySource {
    @Nullable
    private final BodySource delegate;
    @Nullable
    private final Body body;
    private final MethodSignature methodSignature;

    public OverridingBodySource(@Nonnull BodySource delegate) {
        this.delegate = delegate;
        this.body = null;
        this.methodSignature = null;
    }

    private OverridingBodySource(@Nonnull BodySource delegate, @Nonnull Body body) {
        this.delegate = delegate;
        this.body = body;
        this.methodSignature = null;
    }

    public OverridingBodySource(@Nonnull MethodSignature methodSignature, @Nonnull Body body) {
        this.delegate = null;
        this.body = body;
        this.methodSignature = methodSignature;
    }

    @Override
    @Nonnull
    public Body resolveBody(@Nonnull Iterable<Modifier> modifiers) throws IOException {
        return this.body != null ? this.body : this.delegate.resolveBody(modifiers);
    }

    @Override
    public Object resolveAnnotationsDefaultValue() {
        return this.delegate.resolveAnnotationsDefaultValue();
    }

    @Override
    @Nonnull
    public MethodSignature getSignature() {
        return this.methodSignature != null ? this.methodSignature : this.delegate.getSignature();
    }

    @Nonnull
    public OverridingBodySource withBody(@Nonnull Body body) {
        return new OverridingBodySource(this.delegate, body);
    }
}

