/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.ForwardingBasicBlock;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.types.ClassType;

public class MutableBasicBlock
implements BasicBlock<MutableBasicBlock> {
    @Nonnull
    private final List<MutableBasicBlock> predecessorBlocks = new ArrayList<MutableBasicBlock>();
    @Nonnull
    private final List<MutableBasicBlock> successorBlocks = new ArrayList<MutableBasicBlock>();
    @Nonnull
    private final Map<ClassType, MutableBasicBlock> exceptionalSuccessorBlocks;
    @Nonnull
    private final List<Stmt> stmts;

    public MutableBasicBlock() {
        this.exceptionalSuccessorBlocks = new HashMap<ClassType, MutableBasicBlock>();
        this.stmts = new ArrayList<Stmt>();
    }

    public MutableBasicBlock(List<Stmt> stmts, Map<ClassType, MutableBasicBlock> exceptionMap) {
        this.stmts = stmts;
        this.exceptionalSuccessorBlocks = exceptionMap;
    }

    public boolean equals(Object o) {
        if (o instanceof ForwardingBasicBlock) {
            return o.equals(this);
        }
        return super.equals(o);
    }

    public void addStmt(@Nonnull Stmt stmt) {
        if (this.getStmtCount() > 0 && this.getTail() instanceof BranchingStmt) {
            throw new IllegalArgumentException("Can't add another Stmt to a Block after a BranchingStmt.");
        }
        this.stmts.add(stmt);
    }

    public void removeStmt(@Nonnull Stmt stmt) {
        this.stmts.remove(stmt);
    }

    public void replaceStmt(Stmt oldStmt, Stmt newStmt) {
        int idx = this.stmts.indexOf(oldStmt);
        if (idx < 0) {
            throw new IllegalArgumentException("oldStmt does not exist in this Block!");
        }
        this.stmts.set(idx, newStmt);
    }

    public void addPredecessorBlock(@Nonnull MutableBasicBlock block) {
        this.predecessorBlocks.add(block);
    }

    public void addSuccessorBlock(@Nonnull MutableBasicBlock block) {
        this.successorBlocks.add(block);
    }

    public void removePredecessorBlock(@Nonnull MutableBasicBlock b) {
        this.predecessorBlocks.remove(b);
    }

    public void removeSuccessorBlock(@Nonnull MutableBasicBlock b) {
        this.successorBlocks.remove(b);
    }

    public void addExceptionalSuccessorBlock(@Nonnull ClassType exception, MutableBasicBlock b) {
        this.exceptionalSuccessorBlocks.put(exception, b);
        b.addPredecessorBlock(this);
    }

    public void removeExceptionalSuccessorBlock(@Nonnull ClassType exception) {
        MutableBasicBlock removedHandlerBlock = this.exceptionalSuccessorBlocks.remove(exception);
        if (removedHandlerBlock == null) {
            throw new IllegalArgumentException("there is no handler for the given ClassType: " + exception);
        }
        removedHandlerBlock.removePredecessorBlock(this);
    }

    public Collection<ClassType> collectExceptionalSuccessorBlocks(@Nonnull MutableBasicBlock block) {
        ArrayDeque<ClassType> q = new ArrayDeque<ClassType>();
        for (Map.Entry<ClassType, MutableBasicBlock> entry : this.exceptionalSuccessorBlocks.entrySet()) {
            if (entry.getValue() != block) continue;
            q.add(entry.getKey());
        }
        return q;
    }

    @Override
    @Nonnull
    public List<MutableBasicBlock> getPredecessors() {
        return Collections.unmodifiableList(this.predecessorBlocks);
    }

    @Override
    @Nonnull
    public List<MutableBasicBlock> getSuccessors() {
        return Collections.unmodifiableList(this.successorBlocks);
    }

    @Override
    public List<MutableBasicBlock> getExceptionalPredecessors() {
        throw new UnsupportedOperationException("not implemented.");
    }

    @Override
    @Nonnull
    public Map<ClassType, MutableBasicBlock> getExceptionalSuccessors() {
        return Collections.unmodifiableMap(this.exceptionalSuccessorBlocks);
    }

    @Override
    @Nonnull
    public List<Stmt> getStmts() {
        return Collections.unmodifiableList(this.stmts);
    }

    @Override
    public int getStmtCount() {
        return this.stmts.size();
    }

    @Override
    @Nonnull
    public Stmt getHead() {
        if (this.stmts.size() < 1) {
            throw new IndexOutOfBoundsException("Cant get the head - this Block has no assigned Stmts.");
        }
        return this.stmts.get(0);
    }

    @Override
    @Nonnull
    public Stmt getTail() {
        int size = this.stmts.size();
        if (size < 1) {
            throw new IndexOutOfBoundsException("Cant get the tail - this Block has no assigned Stmts.");
        }
        return this.stmts.get(size - 1);
    }

    public MutableBasicBlock splitBlockUnlinked(@Nonnull Stmt newTail, @Nonnull Stmt newHead) {
        int splitIdx = this.stmts.indexOf(newTail);
        if (splitIdx < 0) {
            throw new IllegalArgumentException("Can not split by that Stmt - it is not contained in this Block.");
        }
        if (this.stmts.get(splitIdx + 1) != newHead) {
            throw new IllegalArgumentException("Can't split - the given Stmts are not connected.");
        }
        return this.splitBlockUnlinked(splitIdx + 1);
    }

    protected MutableBasicBlock splitBlockUnlinked(int splitIdx) {
        if (splitIdx < 1 || splitIdx >= this.stmts.size()) {
            throw new IndexOutOfBoundsException("splitIdx makes no sense. please copy/create a new block.");
        }
        MutableBasicBlock secondBlock = new MutableBasicBlock(new ArrayList<Stmt>(this.stmts.size() - splitIdx), new LinkedHashMap<ClassType, MutableBasicBlock>());
        for (int i = splitIdx; i < this.stmts.size(); ++i) {
            secondBlock.addStmt(this.stmts.get(i));
        }
        if (splitIdx < this.stmts.size()) {
            this.stmts.subList(splitIdx, this.stmts.size()).clear();
        }
        return secondBlock;
    }

    @Nonnull
    public MutableBasicBlock splitBlockLinked(@Nonnull Stmt splitStmt, boolean shouldBeNewHead) {
        int splitIdx = this.stmts.indexOf(splitStmt);
        if (splitIdx < 0) {
            throw new IllegalArgumentException("splitting Stmt is not contained in this Block.");
        }
        if (!shouldBeNewHead) {
            ++splitIdx;
        }
        MutableBasicBlock newBlock = this.splitBlockUnlinked(splitIdx);
        this.successorBlocks.forEach(succBlock -> {
            newBlock.addSuccessorBlock((MutableBasicBlock)succBlock);
            succBlock.removePredecessorBlock(this);
            succBlock.addPredecessorBlock(newBlock);
        });
        this.successorBlocks.clear();
        newBlock.addPredecessorBlock(this);
        this.addSuccessorBlock(newBlock);
        return newBlock;
    }

    public void copyExceptionalFlowFrom(MutableBasicBlock sourceBlock) {
        this.exceptionalSuccessorBlocks.putAll(sourceBlock.getExceptionalSuccessors());
        this.exceptionalSuccessorBlocks.forEach((type, exBlock) -> exBlock.addPredecessorBlock(this));
    }

    public void clearSuccessorBlocks() {
        this.successorBlocks.forEach(b -> b.removePredecessorBlock(this));
        this.successorBlocks.clear();
    }

    public void clearExceptionalSuccessorBlocks() {
        this.exceptionalSuccessorBlocks.forEach((e, b) -> b.removePredecessorBlock(this));
        this.exceptionalSuccessorBlocks.clear();
    }

    public void clearPredecessorBlocks() {
        HashMap<MutableBasicBlock, Collection> toRemove = new HashMap<MutableBasicBlock, Collection>();
        this.predecessorBlocks.forEach(pb -> {
            pb.removeSuccessorBlock(this);
            toRemove.put((MutableBasicBlock)pb, pb.collectExceptionalSuccessorBlocks(this));
        });
        toRemove.forEach((predBlock, cltypes) -> {
            for (ClassType type : cltypes) {
                predBlock.removeExceptionalSuccessorBlock(type);
            }
        });
        this.predecessorBlocks.clear();
    }

    public String toString() {
        return "Block " + this.getStmts();
    }
}

