/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.ForwardingBasicBlock;
import sootup.core.graph.ForwardingStmtGraph;
import sootup.core.graph.MutableBasicBlock;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.LocalGenerator;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public class MutableBlockStmtGraph
extends MutableStmtGraph {
    @Nullable
    private Stmt startingStmt = null;
    @Nonnull
    private final Map<Stmt, MutableBasicBlock> stmtToBlock = new HashMap<Stmt, MutableBasicBlock>();
    @Nonnull
    private final Set<MutableBasicBlock> blocks = new HashSet<MutableBasicBlock>();

    public MutableBlockStmtGraph() {
    }

    public MutableBlockStmtGraph(boolean isStatic, MethodSignature sig, LocalGenerator localgen) {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(sig.getParameterTypes().size() + (isStatic ? 0 : 1));
        if (!isStatic) {
            ClassType thisType = sig.getDeclClassType();
            Local thisLocal = localgen.generateThisLocal(thisType);
            JIdentityStmt<JThisRef> stmt = Jimple.newIdentityStmt(thisLocal, Jimple.newThisRef(thisType), StmtPositionInfo.createNoStmtPositionInfo());
            stmts.add(stmt);
        }
        int i = 0;
        for (Type parameterType : sig.getParameterTypes()) {
            JIdentityStmt<JParameterRef> stmt = Jimple.newIdentityStmt(localgen.generateParameterLocal(parameterType, i), Jimple.newParameterRef(parameterType, i++), StmtPositionInfo.createNoStmtPositionInfo());
            stmts.add(stmt);
        }
        if (!stmts.isEmpty()) {
            this.setStartingStmt((Stmt)stmts.get(0));
            this.addBlock(stmts);
        }
    }

    public MutableBlockStmtGraph(@Nonnull StmtGraph<? extends BasicBlock<?>> graph) {
        this.setStartingStmt(graph.getStartingStmt());
        graph.getBlocks().forEach(b -> {
            Map<ClassType, BasicBlock> exceptionalSuccessors = b.getExceptionalSuccessors();
            HashMap<ClassType, Stmt> exSuccs = new HashMap<ClassType, Stmt>();
            exceptionalSuccessors.forEach((? super K k, ? super V v) -> exSuccs.put((ClassType)k, v.getHead()));
            this.addBlock(b.getStmts(), exSuccs);
        });
        graph.getBlocks().forEach(b -> {
            MutableBasicBlock blockOf = this.stmtToBlock.get(b.getTail());
            b.getSuccessors().forEach(succ -> this.linkBlocks(blockOf, this.stmtToBlock.get(succ.getHead())));
        });
    }

    public void initializeWith(@Nonnull List<Stmt> stmts, @Nonnull Map<BranchingStmt, List<Stmt>> branchingMap, @Nonnull List<Trap> traps) {
        if (stmts.isEmpty()) {
            return;
        }
        Stmt lastStmt = stmts.get(stmts.size() - 1);
        if (lastStmt.fallsThrough()) {
            throw new IllegalArgumentException("Theres a fallsthrough Stmt at the end of the list of stmts ('" + lastStmt + "') which has no sucessor - which means it currently falls into the abyss i.e. it can't fall through to another Stmt.");
        }
        HashMap<Stmt, Integer> trapstmtToIdx = new HashMap<Stmt, Integer>();
        PriorityQueue<Trap> trapStart = new PriorityQueue<Trap>(Comparator.comparingInt(t -> (Integer)trapstmtToIdx.get(t.getBeginStmt())));
        PriorityQueue<Trap> trapEnd = new PriorityQueue<Trap>(Comparator.comparingInt(t -> (Integer)trapstmtToIdx.get(t.getEndStmt())));
        traps.forEach(trap -> {
            trapstmtToIdx.put(trap.getBeginStmt(), stmts.indexOf(trap.getBeginStmt()));
            trapstmtToIdx.put(trap.getEndStmt(), stmts.indexOf(trap.getEndStmt()));
            trapstmtToIdx.put(trap.getHandlerStmt(), stmts.indexOf(trap.getHandlerStmt()));
        });
        MutableBlockStmtGraph.duplicateCatchAllTrapRemover(traps, trapstmtToIdx);
        traps.forEach(trap -> {
            trapStart.add((Trap)trap);
            trapEnd.add((Trap)trap);
        });
        this.setStartingStmt(stmts.get(0));
        HashMap<ClassType, Stmt> exceptionToHandlerMap = new HashMap<ClassType, Stmt>();
        HashMap<ClassType, Object> currentTrapMap = new HashMap<ClassType, Object>();
        HashMap<ClassType, PriorityQueue> overlappingTraps = new HashMap<ClassType, PriorityQueue>();
        Trap nextStartingTrap = trapStart.poll();
        Trap nextEndingTrap = trapEnd.poll();
        int stmtsSize = stmts.size();
        for (int i = 0; i < stmtsSize; ++i) {
            Trap trap2;
            Stmt stmt = stmts.get(i);
            boolean trapsChanged = false;
            while (nextEndingTrap != null && nextEndingTrap.getEndStmt() == stmt) {
                trap2 = nextEndingTrap;
                nextEndingTrap = trapEnd.poll();
                ClassType exceptionType = trap2.getExceptionType();
                boolean isRemoved = currentTrapMap.remove(exceptionType, trap2);
                PriorityQueue overridenTrapHandlers = (PriorityQueue)overlappingTraps.get(exceptionType);
                if (overridenTrapHandlers != null) {
                    if (!isRemoved && overridenTrapHandlers.size() > 0) {
                        overridenTrapHandlers.remove(trap2);
                    }
                    if (overridenTrapHandlers.size() > 0) {
                        currentTrapMap.put(exceptionType, overridenTrapHandlers.poll());
                    }
                }
                trapsChanged = true;
            }
            while (nextStartingTrap != null && nextStartingTrap.getBeginStmt() == stmt) {
                trap2 = nextStartingTrap;
                nextStartingTrap = trapStart.poll();
                Trap existingTrapForException = (Trap)currentTrapMap.get(trap2.getExceptionType());
                if (existingTrapForException == null) {
                    currentTrapMap.put(trap2.getExceptionType(), trap2);
                } else {
                    PriorityQueue overridenTraps = overlappingTraps.computeIfAbsent(trap2.getExceptionType(), k -> new PriorityQueue((trapA, trapB) -> {
                        if (trapA.getEndStmt() == trapB.getEndStmt()) {
                            Integer startIdxA = (Integer)trapstmtToIdx.get(trapA.getBeginStmt());
                            Integer startIdxB = (Integer)trapstmtToIdx.get(trapB.getBeginStmt());
                            return startIdxB - startIdxA;
                        }
                        Integer idxA = (Integer)trapstmtToIdx.get(trapA.getEndStmt());
                        Integer idxB = (Integer)trapstmtToIdx.get(trapB.getEndStmt());
                        return idxA - idxB;
                    }));
                    overridenTraps.add(existingTrapForException);
                    overridenTraps.add(trap2);
                    Trap trapToApply = (Trap)overridenTraps.poll();
                    currentTrapMap.put(trapToApply.getExceptionType(), trapToApply);
                }
                trapsChanged = true;
            }
            if (trapsChanged) {
                exceptionToHandlerMap.clear();
                currentTrapMap.forEach((? super K type, ? super V trap) -> exceptionToHandlerMap.put((ClassType)type, trap.getHandlerStmt()));
            }
            this.addNode(stmt, exceptionToHandlerMap);
            if (stmt.fallsThrough()) {
                this.putEdge(stmt, stmts.get(i + 1));
            }
            if (!(stmt instanceof BranchingStmt)) continue;
            List<Stmt> targets = branchingMap.get(stmt);
            int expectedBranchEntries = stmt.getExpectedSuccessorCount() - (stmt.fallsThrough() ? 1 : 0);
            if (targets == null || targets.size() != expectedBranchEntries) {
                int targetCount = targets == null ? 0 : targets.size();
                throw new IllegalArgumentException("The corresponding branchingMap entry for the BranchingStmt ('" + stmt + "') needs to have exactly the amount of targets as the BranchingStmt has successors i.e. " + expectedBranchEntries + " but has " + targetCount + ".");
            }
            for (Stmt target : targets) {
                this.putEdge(stmt, target);
            }
        }
    }

    private static void duplicateCatchAllTrapRemover(@Nonnull List<Trap> traps, Map<Stmt, Integer> trapstmtToIdx) {
        if (traps.size() > 2) {
            int trapsSize = traps.size();
            for (int i = 0; i < trapsSize; ++i) {
                Trap trap1 = traps.get(i);
                String fullyQualifiedName1 = trap1.getExceptionType().getFullyQualifiedName();
                if (!fullyQualifiedName1.equals("java.lang.Throwable") && !fullyQualifiedName1.equals("java.lang.Exception")) continue;
                block1: for (int j = 0; j < trapsSize; ++j) {
                    Trap trap2 = traps.get(j);
                    String fullyQualifiedName2 = trap2.getExceptionType().getFullyQualifiedName();
                    if (trap1 == trap2 || trap1.getBeginStmt() != trap2.getBeginStmt() || trap1.getEndStmt() != trap2.getEndStmt() || !fullyQualifiedName2.equals(fullyQualifiedName1)) continue;
                    for (int k = 0; k < trapsSize; ++k) {
                        Trap trap3 = traps.get(k);
                        int trap3StartIdx = trapstmtToIdx.get(trap3.getBeginStmt());
                        int trap3EndIdx = trapstmtToIdx.get(trap3.getEndStmt());
                        if (trap3 == trap1 || trap3 == trap2 || !trap3.getExceptionType().getFullyQualifiedName().equals(fullyQualifiedName2)) continue;
                        int trap1HandlerIdx = trapstmtToIdx.get(trap1.getHandlerStmt());
                        if (trap3StartIdx <= trap1HandlerIdx && trap1HandlerIdx < trap3EndIdx && trap3.getHandlerStmt() == trap2.getHandlerStmt()) {
                            traps.remove(trap2);
                            --j;
                            --trapsSize;
                            continue block1;
                        }
                        int trap2HandlerIdx = trapstmtToIdx.get(trap2.getHandlerStmt());
                        if (trap3StartIdx > trap2HandlerIdx || trap2HandlerIdx >= trap3EndIdx || trap3.getHandlerStmt() != trap1.getHandlerStmt()) continue;
                        traps.remove(trap1);
                        --i;
                        --trapsSize;
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void addExceptionalEdge(@Nonnull Stmt stmt, @Nonnull ClassType exceptionType, @Nonnull Stmt traphandlerStmt) {
        MutableBasicBlock block = this.stmtToBlock.get(stmt);
        if (block == null) {
            throw new IllegalArgumentException("Stmt is not in the StmtGraph!");
        }
        Map<ClassType, MutableBasicBlock> exceptionalSuccessors = block.getExceptionalSuccessors();
        MutableBasicBlock trapBlock = exceptionalSuccessors.get(exceptionType);
        if (trapBlock != null && trapBlock.getHead() == traphandlerStmt) {
            return;
        }
        MutableBasicBlock seperatedBlock = this.excludeStmtFromBlock(stmt, block);
        seperatedBlock.addExceptionalSuccessorBlock(exceptionType, this.getOrCreateBlock(traphandlerStmt));
        this.tryMergeIntoSurroundingBlocks(seperatedBlock);
    }

    @Override
    public void removeExceptionalEdge(@Nonnull Stmt node, @Nonnull ClassType exceptionType) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt is not in the StmtGraph!");
        }
        block.removeExceptionalSuccessorBlock(exceptionType);
        this.tryMergeIntoSurroundingBlocks(block);
    }

    @Override
    public void clearExceptionalEdges(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt is not in the StmtGraph!");
        }
        block.clearExceptionalSuccessorBlocks();
        this.tryMergeIntoSurroundingBlocks(block);
    }

    @Nonnull
    public Set<? extends BasicBlock<?>> getBlocks() {
        return this.blocks.stream().map(ForwardingBasicBlock::new).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public List<? extends BasicBlock<?>> getBlocksSorted() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.blocks.iterator(), 16), false).map(ForwardingBasicBlock::new).collect(Collectors.toList());
    }

    @Override
    public void addBlock(@Nonnull List<Stmt> stmts, @Nonnull Map<ClassType, Stmt> trapMap) {
        if (stmts.isEmpty()) {
            return;
        }
        this.addBlockInternal(stmts, trapMap);
    }

    private MutableBasicBlock addBlockInternal(@Nonnull List<Stmt> stmts, Map<ClassType, Stmt> trapMap) {
        Iterator<Stmt> iterator = stmts.iterator();
        Stmt node = iterator.next();
        MutableBasicBlock block = this.getOrCreateBlock(node);
        if (block.getHead() != node || block.getSuccessors().size() > 0) {
            throw new IllegalArgumentException("The first Stmt in the List is already in the StmtGraph and and is not the head of a Block where currently no successor are set, yet.");
        }
        if (block.getStmtCount() > 1) {
            throw new IllegalArgumentException("The first Stmt in the List is already in the StmtGraph and has at least one (fallsthrough) successor in its Block.");
        }
        while (iterator.hasNext()) {
            Stmt stmt = iterator.next();
            MutableBasicBlock overwrittenBlock = this.addNodeToBlock(block, stmt);
            if (overwrittenBlock == null) continue;
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("the Stmt '" + stmt + "' you want to add as a Stmt of a whole Block is already in this StmtGraph.");
            }
            if (overwrittenBlock.getHead() == stmt) {
                this.stmtToBlock.put(stmt, overwrittenBlock);
                block.removeStmt(stmt);
                if (this.tryMergeBlocks(block, overwrittenBlock)) continue;
                this.linkBlocks(block, overwrittenBlock);
                continue;
            }
            throw new IllegalArgumentException("the Stmt '" + stmt + "' you want to add as a Stmt of a whole Block is already in this StmtGraph.");
        }
        trapMap.forEach((? super K type, ? super V handlerStmt) -> block.addExceptionalSuccessorBlock((ClassType)type, this.getOrCreateBlock((Stmt)handlerStmt)));
        return block;
    }

    @Override
    public void addNode(@Nonnull Stmt stmt, @Nonnull Map<ClassType, Stmt> exceptions) {
        MutableBasicBlock block = this.stmtToBlock.get(stmt);
        if (block == null) {
            block = this.createStmtsBlock(stmt);
        }
        boolean isExceptionalFlowDifferent = false;
        if (block.getExceptionalSuccessors().size() == exceptions.size()) {
            for (Map.Entry<ClassType, MutableBasicBlock> entry : block.getExceptionalSuccessors().entrySet()) {
                Stmt targetStmt = exceptions.get(entry.getKey());
                if (targetStmt == null) {
                    isExceptionalFlowDifferent = true;
                } else {
                    if (targetStmt == entry.getValue().getHead()) continue;
                    isExceptionalFlowDifferent = true;
                }
                break;
            }
        } else {
            isExceptionalFlowDifferent = true;
        }
        if (isExceptionalFlowDifferent) {
            MutableBasicBlock separatedBlock = this.excludeStmtFromBlock(stmt, block);
            separatedBlock.clearExceptionalSuccessorBlocks();
            exceptions.forEach((? super K type, ? super V trapHandler) -> {
                MutableBasicBlock trapHandlerBlock = this.getOrCreateBlock((Stmt)trapHandler);
                separatedBlock.addExceptionalSuccessorBlock((ClassType)type, trapHandlerBlock);
                trapHandlerBlock.addPredecessorBlock(separatedBlock);
            });
            this.tryMergeIntoSurroundingBlocks(separatedBlock);
        }
    }

    @Nonnull
    private MutableBasicBlock excludeStmtFromBlock(@Nonnull Stmt splitStmt, MutableBasicBlock block) {
        if (block.getStmtCount() > 1) {
            MutableBasicBlock excludedFromOrigBlock;
            List<Stmt> blockStmts = block.getStmts();
            int stmtIdx = blockStmts.indexOf(splitStmt);
            if (stmtIdx < 0) {
                throw new IllegalArgumentException("splitStmt does not exist in this block!");
            }
            if (stmtIdx == 0) {
                excludedFromOrigBlock = block;
            } else {
                excludedFromOrigBlock = new MutableBasicBlock();
                this.addNodeToBlock(excludedFromOrigBlock, splitStmt);
                block.getExceptionalSuccessors().forEach((? super K type, ? super V trapHandlerBlock) -> {
                    excludedFromOrigBlock.addExceptionalSuccessorBlock((ClassType)type, (MutableBasicBlock)trapHandlerBlock);
                    trapHandlerBlock.addPredecessorBlock(excludedFromOrigBlock);
                });
                this.blocks.add(excludedFromOrigBlock);
            }
            if (stmtIdx + 1 < blockStmts.size()) {
                MutableBasicBlock restOfOrigBlock = new MutableBasicBlock();
                for (int i = stmtIdx + 1; i < blockStmts.size(); ++i) {
                    this.addNodeToBlock(restOfOrigBlock, blockStmts.get(i));
                }
                block.getSuccessors().forEach(successor -> this.linkBlocks(restOfOrigBlock, (MutableBasicBlock)successor));
                block.clearSuccessorBlocks();
                this.linkBlocks(excludedFromOrigBlock, restOfOrigBlock);
                block.clearSuccessorBlocks();
                block.getExceptionalSuccessors().forEach((? super K type, ? super V trapHandlerBlock) -> {
                    restOfOrigBlock.addExceptionalSuccessorBlock((ClassType)type, (MutableBasicBlock)trapHandlerBlock);
                    trapHandlerBlock.addPredecessorBlock(restOfOrigBlock);
                });
                this.blocks.add(restOfOrigBlock);
            } else {
                block.getSuccessors().forEach(successorBlock -> this.linkBlocks(excludedFromOrigBlock, (MutableBasicBlock)successorBlock));
                block.clearSuccessorBlocks();
                this.linkBlocks(block, excludedFromOrigBlock);
            }
            for (int i = blockStmts.size() - 1; i >= stmtIdx; --i) {
                block.removeStmt(blockStmts.get(i));
            }
            return excludedFromOrigBlock;
        }
        return block;
    }

    private void tryMergeIntoSurroundingBlocks(@Nonnull MutableBasicBlock block) {
        block = this.tryMergeWithPredecessorBlock(block);
        this.tryMergeWithSuccessorBlock(block);
    }

    @Nonnull
    private MutableBasicBlock tryMergeWithSuccessorBlock(@Nonnull MutableBasicBlock block) {
        MutableBasicBlock singleSuccessor;
        List<MutableBasicBlock> successors = block.getSuccessors();
        if (successors.size() == 1 && this.tryMergeBlocks(block, singleSuccessor = successors.get(0))) {
            return singleSuccessor;
        }
        return block;
    }

    @Nonnull
    private MutableBasicBlock tryMergeWithPredecessorBlock(@Nonnull MutableBasicBlock block) {
        MutableBasicBlock singlePredecessor;
        List<MutableBasicBlock> predecessors = block.getPredecessors();
        if (predecessors.size() == 1 && this.tryMergeBlocks(singlePredecessor = predecessors.get(0), block)) {
            return singlePredecessor;
        }
        return block;
    }

    @Nonnull
    private MutableBasicBlock getOrCreateBlock(@Nonnull Stmt stmt) {
        MutableBasicBlock trapHandlerBlock = this.stmtToBlock.get(stmt);
        if (trapHandlerBlock == null) {
            trapHandlerBlock = this.createStmtsBlock(stmt);
        }
        return trapHandlerBlock;
    }

    protected boolean isMergeable(@Nonnull MutableBasicBlock firstBlock, @Nonnull MutableBasicBlock followingBlock) {
        if (firstBlock.getTail().branches()) {
            return false;
        }
        List<MutableBasicBlock> fBlocksuccessors = firstBlock.getSuccessors();
        if (fBlocksuccessors.size() != 1 || fBlocksuccessors.get(0) != followingBlock) {
            return false;
        }
        List<MutableBasicBlock> sBlockPredecessors = followingBlock.getPredecessors();
        if (sBlockPredecessors.size() != 1 || sBlockPredecessors.get(0) != firstBlock) {
            return false;
        }
        return firstBlock.getExceptionalSuccessors().equals(followingBlock.getExceptionalSuccessors());
    }

    protected boolean tryMergeBlocks(@Nonnull MutableBasicBlock firstBlock, @Nonnull MutableBasicBlock followingBlock) {
        boolean mergeable = this.isMergeable(firstBlock, followingBlock);
        if (mergeable) {
            for (Stmt stmt : followingBlock.getStmts()) {
                this.addNodeToBlock(firstBlock, stmt);
            }
            firstBlock.clearSuccessorBlocks();
            followingBlock.getSuccessors().forEach(succ -> this.linkBlocks(firstBlock, (MutableBasicBlock)succ));
            followingBlock.clearSuccessorBlocks();
            this.blocks.remove(followingBlock);
            followingBlock.clearPredecessorBlocks();
        }
        return mergeable;
    }

    @Nonnull
    protected MutableBasicBlock createStmtsBlock(@Nonnull Stmt stmt) {
        MutableBasicBlock block = new MutableBasicBlock();
        if (this.addNodeToBlock(block, stmt) != null) {
            throw new IllegalArgumentException("Stmt is already in the graph!");
        }
        this.blocks.add(block);
        return block;
    }

    protected MutableBasicBlock addNodeToBlock(@Nonnull MutableBasicBlock block, @Nonnull Stmt stmt) {
        block.addStmt(stmt);
        return this.stmtToBlock.put(stmt, block);
    }

    @Override
    public void removeNode(@Nonnull Stmt stmt) {
        this.removeNode(stmt, true);
    }

    public void removeNode(@Nonnull Stmt stmt, boolean keepFlow) {
        boolean isTail;
        MutableBasicBlock blockOfRemovedStmt = this.stmtToBlock.remove(stmt);
        if (blockOfRemovedStmt == null) {
            throw new IllegalArgumentException("Stmt is not in the StmtGraph!");
        }
        if (stmt == this.startingStmt) {
            this.startingStmt = null;
        }
        boolean isHead = blockOfRemovedStmt.getHead() == stmt;
        boolean bl = isTail = blockOfRemovedStmt.getTail() == stmt;
        if (isHead && !keepFlow) {
            MutableBasicBlock finalBlockOfRemovedStmt = blockOfRemovedStmt;
            blockOfRemovedStmt.getPredecessors().forEach(b -> {
                b.removeSuccessorBlock(finalBlockOfRemovedStmt);
                finalBlockOfRemovedStmt.removePredecessorBlock((MutableBasicBlock)b);
            });
            blockOfRemovedStmt.clearPredecessorBlocks();
        }
        if (isTail && stmt.branches() && !keepFlow) {
            blockOfRemovedStmt.clearSuccessorBlocks();
        }
        if (blockOfRemovedStmt.getStmtCount() > 1) {
            blockOfRemovedStmt.removeStmt(stmt);
            if (isHead) {
                blockOfRemovedStmt = this.tryMergeWithPredecessorBlock(blockOfRemovedStmt);
            }
            if (isTail) {
                this.tryMergeWithSuccessorBlock(blockOfRemovedStmt);
            }
        } else {
            this.blocks.remove(blockOfRemovedStmt);
            blockOfRemovedStmt.clearPredecessorBlocks();
            blockOfRemovedStmt.clearSuccessorBlocks();
            blockOfRemovedStmt.clearExceptionalSuccessorBlocks();
            blockOfRemovedStmt.removeStmt(stmt);
        }
    }

    @Override
    public void replaceNode(@Nonnull Stmt oldStmt, @Nonnull Stmt newStmt) {
        MutableBasicBlock blockOfOldStmt = this.stmtToBlock.get(oldStmt);
        if (blockOfOldStmt == null) {
            throw new IllegalArgumentException("oldStmt does not exist in the StmtGraph!");
        }
        if (oldStmt == this.startingStmt) {
            this.startingStmt = newStmt;
        }
        if (oldStmt.getExpectedSuccessorCount() != newStmt.getExpectedSuccessorCount()) {
            MutableBasicBlock excludedBlock = this.excludeStmtFromBlock(oldStmt, blockOfOldStmt);
            excludedBlock.replaceStmt(oldStmt, newStmt);
            this.stmtToBlock.remove(oldStmt);
            this.stmtToBlock.put(newStmt, excludedBlock);
        } else {
            this.stmtToBlock.remove(oldStmt);
            blockOfOldStmt.replaceStmt(oldStmt, newStmt);
            this.stmtToBlock.put(newStmt, blockOfOldStmt);
        }
    }

    public void validateBlocks() {
        for (MutableBasicBlock block : this.blocks) {
            for (Stmt stmt : block.getStmts()) {
                if (this.stmtToBlock.get(stmt) == block) continue;
                throw new IllegalStateException("wrong stmt to block mapping");
            }
        }
    }

    @Override
    public void insertBefore(@Nonnull Stmt beforeStmt, @Nonnull List<Stmt> stmts, @Nonnull Map<ClassType, Stmt> exceptionMap) {
        if (stmts.isEmpty()) {
            return;
        }
        MutableBasicBlock block = this.stmtToBlock.get(beforeStmt);
        if (block.getHead() == beforeStmt) {
            MutableBasicBlock predecessorBlock = this.addBlockInternal(stmts, exceptionMap);
            for (MutableBasicBlock predecessor : block.getPredecessors()) {
                predecessor.removeSuccessorBlock(block);
                block.removePredecessorBlock(predecessor);
                this.linkBlocks(predecessor, predecessorBlock);
            }
            this.tryMergeBlocks(predecessorBlock, block);
        } else {
            MutableBasicBlock successorBlock = block.splitBlockLinked(beforeStmt, true);
            exceptionMap.forEach((? super K type, ? super V handler) -> successorBlock.addExceptionalSuccessorBlock((ClassType)type, this.getOrCreateBlock((Stmt)handler)));
            stmts.forEach(stmt -> this.addNodeToBlock(block, (Stmt)stmt));
            this.tryMergeBlocks(block, successorBlock);
        }
        if (beforeStmt == this.getStartingStmt()) {
            this.setStartingStmt(stmts.get(0));
        }
    }

    @Override
    public void putEdge(@Nonnull Stmt stmtA, @Nonnull Stmt stmtB) {
        MutableBasicBlock blockA = this.stmtToBlock.get(stmtA);
        MutableBasicBlock blockB = this.stmtToBlock.get(stmtB);
        if (blockA == null) {
            blockA = this.createStmtsBlock(stmtA);
        } else if (blockA.getTail() != stmtA) {
            throw new IllegalArgumentException("StmtA '" + stmtA + "' is not at the end of a block but it must be to reach StmtB '" + stmtB + "'.");
        }
        if (blockA.getSuccessors().size() >= stmtA.getExpectedSuccessorCount()) {
            throw new IllegalArgumentException("Can't add another flow - there are already enough flows i.e. " + stmtA.getExpectedSuccessorCount() + " outgoing from StmtA '" + stmtA + "'");
        }
        if (stmtA.branches()) {
            if (blockB == null) {
                blockB = this.createStmtsBlock(stmtB);
                this.linkBlocks(blockA, blockB);
            } else if (blockB.getHead() == stmtB) {
                this.linkBlocks(blockA, blockB);
            } else {
                MutableBasicBlock newBlock = blockB.splitBlockLinked(stmtB, true);
                newBlock.copyExceptionalFlowFrom(blockB);
                this.blocks.add(newBlock);
                newBlock.getStmts().forEach(stmt -> this.stmtToBlock.put((Stmt)stmt, newBlock));
                if (blockA == blockB) {
                    this.linkBlocks(newBlock, newBlock);
                } else {
                    this.linkBlocks(blockA, newBlock);
                }
            }
        } else if (blockB == null) {
            this.addNodeToBlock(blockA, stmtB);
        } else if (blockB.getHead() == stmtB) {
            if (blockB.getPredecessors().isEmpty() && blockA.getExceptionalSuccessors().equals(blockB.getExceptionalSuccessors())) {
                for (Stmt stmt2 : blockB.getStmts()) {
                    this.addNodeToBlock(blockA, stmt2);
                }
                this.blocks.remove(blockB);
            } else {
                this.linkBlocks(blockA, blockB);
            }
        } else {
            throw new IllegalArgumentException("StmtB '" + stmtB + "' is already in the Graph and has already a non-branching predecessor!");
        }
    }

    private void linkBlocks(@Nonnull MutableBasicBlock blockA, @Nonnull MutableBasicBlock blockB) {
        blockA.addSuccessorBlock(blockB);
        blockB.addPredecessorBlock(blockA);
    }

    @Override
    public void removeEdge(@Nonnull Stmt from, @Nonnull Stmt to) {
        List<Stmt> stmtsOfBlock;
        int toIdx;
        MutableBasicBlock blockOfFrom = this.stmtToBlock.get(from);
        MutableBasicBlock blockOfTo = this.stmtToBlock.get(to);
        if (blockOfFrom == null || blockOfTo == null) {
            return;
        }
        this.removeBlockBorderEdgesInternal(from, blockOfFrom);
        if (blockOfFrom == blockOfTo && (toIdx = (stmtsOfBlock = blockOfFrom.getStmts()).indexOf(from) + 1) < stmtsOfBlock.size() && stmtsOfBlock.get(toIdx) == to) {
            MutableBasicBlock newBlock = blockOfFrom.splitBlockUnlinked(from, to);
            newBlock.copyExceptionalFlowFrom(blockOfFrom);
            blockOfFrom.getSuccessors().forEach(newBlock::addSuccessorBlock);
            blockOfFrom.clearSuccessorBlocks();
            this.blocks.add(newBlock);
            newBlock.getStmts().forEach(s2 -> this.stmtToBlock.put((Stmt)s2, newBlock));
        }
    }

    protected void removeBlockBorderEdgesInternal(@Nonnull Stmt from, @Nonnull MutableBasicBlock blockOfFrom) {
        if (blockOfFrom.getStmts().size() > 0 && from == blockOfFrom.getTail()) {
            MutableBasicBlock singlePreviousBlock;
            if (blockOfFrom.getPredecessors().size() == 1 && !(singlePreviousBlock = blockOfFrom.getPredecessors().get(0)).getTail().branches() && singlePreviousBlock != blockOfFrom && singlePreviousBlock.getExceptionalSuccessors().equals(blockOfFrom.getExceptionalSuccessors())) {
                blockOfFrom.getStmts().forEach(k -> this.addNodeToBlock(blockOfFrom, (Stmt)k));
                return;
            }
            if (!from.branches()) {
                MutableBasicBlock singleSuccessorBlock;
                if (blockOfFrom.getStmts().size() > 0 && blockOfFrom.getSuccessors().size() == 1 && (singleSuccessorBlock = blockOfFrom.getSuccessors().get(0)).getPredecessors().size() == 1 && singleSuccessorBlock.getPredecessors().get(0) == blockOfFrom && singleSuccessorBlock.getExceptionalSuccessors().equals(blockOfFrom.getExceptionalSuccessors())) {
                    singleSuccessorBlock.getStmts().forEach(k -> this.addNodeToBlock(blockOfFrom, (Stmt)k));
                }
            } else {
                blockOfFrom.clearSuccessorBlocks();
            }
        }
    }

    @Override
    public void setEdges(@Nonnull Stmt fromStmt, @Nonnull List<Stmt> targets) {
        if (fromStmt.getExpectedSuccessorCount() != targets.size()) {
            throw new IllegalArgumentException("Size of Targets is not the amount of from's expected successors.");
        }
        MutableBasicBlock fromBlock = this.getOrCreateBlock(fromStmt);
        if (fromBlock.getTail() == fromStmt) {
            fromBlock.clearSuccessorBlocks();
        }
        targets.forEach(target -> this.putEdge(fromStmt, (Stmt)target));
    }

    @Override
    @Nullable
    public Stmt getStartingStmt() {
        if (this.stmtToBlock.get(this.startingStmt) == null) {
            return null;
        }
        return this.startingStmt;
    }

    @Override
    @Nullable
    public BasicBlock<?> getStartingStmtBlock() {
        return this.getBlockOf(this.startingStmt);
    }

    @Override
    @Nullable
    public BasicBlock<?> getBlockOf(@Nonnull Stmt stmt) {
        return new ForwardingBasicBlock<BasicBlock>(this.stmtToBlock.get(stmt));
    }

    @Override
    @Nonnull
    public StmtGraph<?> unmodifiableStmtGraph() {
        return new ForwardingStmtGraph<MutableBasicBlock>(this);
    }

    @Override
    public void setStartingStmt(@Nonnull Stmt startingStmt) {
        MutableBasicBlock block;
        if (this.stmtToBlock.get(startingStmt) == null && (block = this.stmtToBlock.get(startingStmt)) == null) {
            this.createStmtsBlock(startingStmt);
        }
        this.startingStmt = startingStmt;
    }

    @Nonnull
    public Set<Stmt> nodes() {
        return this.stmtToBlock.keySet();
    }

    @Override
    public boolean containsNode(@Nonnull Stmt node) {
        return this.stmtToBlock.containsKey(node);
    }

    @Override
    @Nonnull
    public List<Stmt> predecessors(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt '" + node + "' is not contained in the BlockStmtGraph");
        }
        if (node == block.getHead()) {
            List<MutableBasicBlock> predecessorBlocks = block.getPredecessors();
            ArrayList<Stmt> preds = new ArrayList<Stmt>(predecessorBlocks.size());
            predecessorBlocks.forEach(p -> preds.add(p.getTail()));
            return preds;
        }
        List<Stmt> stmts = block.getStmts();
        int i = stmts.indexOf(node);
        return Collections.singletonList(stmts.get(i - 1));
    }

    @Override
    @Nonnull
    public List<Stmt> exceptionalPredecessors(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt is not in the StmtGraph.");
        }
        if (block.getHead() != node) {
            return Collections.emptyList();
        }
        return this.exceptionalPredecessors(block);
    }

    public List<Stmt> exceptionalPredecessors(@Nonnull MutableBasicBlock block) {
        Stmt head = block.getHead();
        if (!(head instanceof JIdentityStmt) || !(((JIdentityStmt)head).getRightOp() instanceof JCaughtExceptionRef)) {
            return Collections.emptyList();
        }
        ArrayList<Stmt> exceptionalPred = new ArrayList<Stmt>();
        for (BasicBlock basicBlock : block.getPredecessors()) {
            if (!basicBlock.getExceptionalSuccessors().containsValue(basicBlock)) continue;
            exceptionalPred.addAll(basicBlock.getStmts());
        }
        return exceptionalPred;
    }

    public List<MutableBasicBlock> exceptionalPredecessorBlocks(@Nonnull MutableBasicBlock block) {
        Stmt head = block.getHead();
        if (!(head instanceof JIdentityStmt) || !(((JIdentityStmt)head).getRightOp() instanceof JCaughtExceptionRef)) {
            return Collections.emptyList();
        }
        ArrayList<MutableBasicBlock> exceptionalPred = new ArrayList<MutableBasicBlock>();
        for (MutableBasicBlock pBlock : block.getPredecessors()) {
            if (!pBlock.getExceptionalSuccessors().containsValue(pBlock)) continue;
            exceptionalPred.add(pBlock);
        }
        return exceptionalPred;
    }

    @Override
    @Nonnull
    public List<Stmt> successors(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt '" + node + "' is not contained in the BlockStmtGraph");
        }
        if (node == block.getTail()) {
            List<MutableBasicBlock> successorBlocks = block.getSuccessors();
            ArrayList<Stmt> succs = new ArrayList<Stmt>(successorBlocks.size());
            successorBlocks.forEach(p -> succs.add(p.getHead()));
            return succs;
        }
        List<Stmt> stmts = block.getStmts();
        return Collections.singletonList(stmts.get(stmts.indexOf(node) + 1));
    }

    @Override
    @Nonnull
    public Map<ClassType, Stmt> exceptionalSuccessors(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt '" + node + "' is not contained in the BlockStmtGraph");
        }
        HashMap<ClassType, Stmt> map = new HashMap<ClassType, Stmt>();
        for (Map.Entry<ClassType, MutableBasicBlock> b : block.getExceptionalSuccessors().entrySet()) {
            map.put(b.getKey(), b.getValue().getHead());
        }
        return map;
    }

    @Override
    public int inDegree(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt '" + node + "' is not contained in the BlockStmtGraph");
        }
        if (node == block.getHead()) {
            return block.getPredecessors().size();
        }
        return 1;
    }

    @Override
    public int outDegree(@Nonnull Stmt node) {
        MutableBasicBlock block = this.stmtToBlock.get(node);
        if (block == null) {
            throw new IllegalArgumentException("Stmt '" + node + "' is not contained in the BlockStmtGraph");
        }
        if (node == block.getTail()) {
            return block.getSuccessors().size();
        }
        return 1;
    }

    @Override
    public boolean hasEdgeConnecting(@Nonnull Stmt source, @Nonnull Stmt target) {
        MutableBasicBlock blockA = this.stmtToBlock.get(source);
        if (blockA == null) {
            throw new IllegalArgumentException("source Stmt is not contained in the BlockStmtGraph: " + source);
        }
        if (source == blockA.getTail()) {
            MutableBasicBlock blockB = this.stmtToBlock.get(source);
            if (blockB == null) {
                throw new IllegalArgumentException("target Stmt is not contained in the BlockStmtGraph: " + source);
            }
            return blockA.getSuccessors().stream().anyMatch(successorBlock -> successorBlock.getHead() == target);
        }
        List<Stmt> stmtsA = blockA.getStmts();
        return stmtsA.get(stmtsA.indexOf(source) + 1) == target;
    }

    public Comparator<Trap> getTrapComparator(@Nonnull HashMap<Stmt, Integer> stmtsBlockIdx) {
        return (a, b) -> ComparisonChain.start().compare((Comparable)stmtsBlockIdx.get(a.getBeginStmt()), (Comparable)stmtsBlockIdx.get(b.getBeginStmt())).compare((Comparable)stmtsBlockIdx.get(a.getEndStmt()), (Comparable)stmtsBlockIdx.get(b.getEndStmt())).compare((Comparable<?>)((Object)a.getExceptionType().toString()), (Comparable<?>)((Object)b.getExceptionType().toString())).result();
    }

    @Override
    public List<Trap> getTraps() {
        StmtGraph.BlockGraphIteratorAndTrapAggregator it = new StmtGraph.BlockGraphIteratorAndTrapAggregator((StmtGraph)this, (BasicBlock)new MutableBasicBlock());
        HashMap<Stmt, Integer> stmtsBlockIdx = new HashMap<Stmt, Integer>();
        int i = 0;
        while (it.hasNext()) {
            Object nextBlock = it.next();
            stmtsBlockIdx.put(nextBlock.getHead(), i);
            stmtsBlockIdx.put(nextBlock.getTail(), i);
            ++i;
        }
        List<Trap> traps = it.getTraps();
        traps.sort(this.getTrapComparator(stmtsBlockIdx));
        return traps;
    }
}

