/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.basic;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.visitor.AbstractTypeVisitor;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public class LocalGenerator {
    private final Set<Local> locals;
    @Nullable
    private Local thisLocal;
    private final Map<Integer, Local> parameterLocals = new HashMap<Integer, Local>();
    NamingSwitch ns = new NamingSwitch(new StringBuilder(7));

    public LocalGenerator(@Nonnull Set<Local> existingLocals) {
        this.locals = existingLocals;
    }

    public Local generateThisLocal(@Nonnull Type type) {
        if (this.thisLocal == null) {
            this.thisLocal = this.generateFieldLocal(type);
        }
        return this.thisLocal;
    }

    public Local generateFieldLocal(@Nonnull Type type) {
        Local localCandidate;
        StringBuilder name = (StringBuilder)this.ns.getResult();
        do {
            name.setLength(0);
            type.accept(this.ns);
        } while (this.locals.contains(localCandidate = Jimple.newLocal(name.toString(), type)));
        this.locals.add(localCandidate);
        return localCandidate;
    }

    public Local generateLocal(@Nonnull Type type) {
        StringBuilder name = (StringBuilder)this.ns.getResult();
        name.setLength(0);
        name.append("$");
        type.accept(this.ns);
        Local localCandidate = Jimple.newLocal(name.toString(), type);
        while (this.locals.contains(localCandidate)) {
            name.setLength(1);
            type.accept(this.ns);
            localCandidate = Jimple.newLocal(name.toString(), type);
        }
        this.locals.add(localCandidate);
        return localCandidate;
    }

    public Local generateParameterLocal(@Nonnull Type type, int index) {
        if (!this.parameterLocals.containsKey(index)) {
            Local paraLocal = this.generateLocal(type);
            this.parameterLocals.put(index, paraLocal);
        }
        return this.parameterLocals.get(index);
    }

    public Set<Local> getLocals() {
        return this.locals;
    }

    @Nullable
    public Local getThisLocal() {
        return this.thisLocal;
    }

    public Local getParameterLocal(int i) {
        return this.parameterLocals.get(i);
    }

    private static class NamingSwitch
    extends AbstractTypeVisitor<StringBuilder> {
        private int tempInt = 0;
        private int tempBoolean = 0;
        private int tempLong = 0;
        private int tempDouble = 0;
        private int tempFloat = 0;
        private int tempRefLikeType = 0;
        private int tempByte = 0;
        private int tempShort = 0;
        private int tempChar = 0;
        private int tempUnknownType = 0;

        private NamingSwitch(@Nonnull StringBuilder str) {
            this.result = str;
        }

        @Override
        public void caseBooleanType() {
            ((StringBuilder)this.result).append("z").append(this.tempBoolean++);
        }

        @Override
        public void caseByteType() {
            ((StringBuilder)this.result).append("b").append(this.tempByte++);
        }

        @Override
        public void caseCharType() {
            ((StringBuilder)this.result).append("c").append(this.tempChar++);
        }

        @Override
        public void caseShortType() {
            ((StringBuilder)this.result).append("s").append(this.tempShort++);
        }

        @Override
        public void caseIntType() {
            ((StringBuilder)this.result).append("i").append(this.tempInt++);
        }

        @Override
        public void caseLongType() {
            ((StringBuilder)this.result).append("l").append(this.tempLong++);
        }

        @Override
        public void caseDoubleType() {
            ((StringBuilder)this.result).append("d").append(this.tempDouble++);
        }

        @Override
        public void caseFloatType() {
            ((StringBuilder)this.result).append("f").append(this.tempFloat++);
        }

        @Override
        public void caseArrayType() {
            ((StringBuilder)this.result).append("r").append(this.tempRefLikeType++);
        }

        @Override
        public void caseClassType(@Nonnull ClassType classType) {
            ((StringBuilder)this.result).append("r").append(this.tempRefLikeType++);
        }

        @Override
        public void caseNullType() {
            this.defaultCaseType();
        }

        @Override
        public void caseVoidType() {
            this.defaultCaseType();
        }

        @Override
        public void caseUnknownType() {
            ((StringBuilder)this.result).append("u").append(this.tempUnknownType++);
        }

        @Override
        public void defaultCaseType() {
            throw new IllegalStateException("Unhandled Type of Local variable to Generate!");
        }
    }
}

