/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.basic;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.Position;
import sootup.core.util.Copyable;

public final class StmtPositionInfo
implements Copyable {
    private final Position stmtPosition;
    private final Position[] operandPositions;

    public static StmtPositionInfo createNoStmtPositionInfo() {
        return new StmtPositionInfo(null, null);
    }

    public StmtPositionInfo(int lineNumber) {
        this.stmtPosition = new Position(lineNumber, -1, lineNumber, -1);
        this.operandPositions = null;
    }

    public StmtPositionInfo(Position stmtPosition, Position[] operandPositions) {
        this.stmtPosition = stmtPosition;
        this.operandPositions = operandPositions;
    }

    public Position getStmtPosition() {
        if (this.stmtPosition != null) {
            return this.stmtPosition;
        }
        return NoPositionInformation.getInstance();
    }

    public Position getOperandPosition(int index) {
        if (this.operandPositions != null && index >= 0 && index < this.operandPositions.length) {
            return this.operandPositions[index];
        }
        return NoPositionInformation.getInstance();
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("stmtPosition: ").append(this.getStmtPosition().toString()).append("\n");
        s2.append("operandPositions: ");
        if (this.operandPositions != null) {
            s2.append("\n");
            for (int i = 0; i < this.operandPositions.length; ++i) {
                s2.append(i).append(": ").append(this.operandPositions[i]).append(" ");
            }
        } else {
            s2.append("No position info");
        }
        return s2.toString();
    }

    @Nonnull
    public StmtPositionInfo withStmtPosition(Position stmtPosition) {
        return new StmtPositionInfo(stmtPosition, this.operandPositions);
    }

    @Nonnull
    public StmtPositionInfo withOperandPositions(Position[] operandPositions) {
        return new StmtPositionInfo(this.stmtPosition, operandPositions);
    }
}

