/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.ComparableConstant;
import sootup.core.jimple.common.constant.LogicalConstant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;

public class BooleanConstant
implements LogicalConstant<BooleanConstant>,
ComparableConstant<BooleanConstant> {
    private static final BooleanConstant FALSE = new BooleanConstant(false);
    private static final BooleanConstant TRUE = new BooleanConstant(true);
    private final boolean value;

    private BooleanConstant(@Nonnull boolean value) {
        this.value = value;
    }

    public static BooleanConstant getInstance(@Nonnull boolean value) {
        return value ? TRUE : FALSE;
    }

    public static BooleanConstant getInstance(@Nonnull int value) {
        if (value == 1) {
            return TRUE;
        }
        if (value == 0) {
            return FALSE;
        }
        throw new RuntimeException("The value of boolean constant can only be 1 or 0");
    }

    public static BooleanConstant getTrue() {
        return TRUE;
    }

    public static BooleanConstant getFalse() {
        return FALSE;
    }

    @Override
    @Nonnull
    public Type getType() {
        return PrimitiveType.getBoolean();
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseBooleanConstant(this);
    }

    @Override
    @Nonnull
    public BooleanConstant equalEqual(@Nonnull BooleanConstant c) {
        return BooleanConstant.getInstance(this.value == c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant notEqual(@Nonnull BooleanConstant c) {
        return BooleanConstant.getInstance(this.value != c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant and(@Nonnull BooleanConstant c) {
        return BooleanConstant.getInstance(this.value & c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant or(@Nonnull BooleanConstant c) {
        return BooleanConstant.getInstance(this.value | c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant xor(@Nonnull BooleanConstant c) {
        return BooleanConstant.getInstance(this.value ^ c.value);
    }

    public String toString() {
        return this.value ? "1" : "0";
    }
}

