/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.signatures.FieldSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public class EnumConstant
implements Constant {
    private final String value;
    private final ClassType type;
    private final FieldSignature signature;

    public EnumConstant(@Nonnull String value, @Nonnull ClassType type) {
        this.value = value;
        this.type = type;
        this.signature = new FieldSignature(type, value, type);
    }

    public boolean equals(Object c) {
        return c instanceof EnumConstant && ((EnumConstant)c).value.equals(this.value) && ((EnumConstant)c).type.equals(this.type);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseEnumConstant(this);
    }

    public String toString() {
        return this.signature.toString();
    }
}

