/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.Type;

public class StringConstant
implements Constant {
    private final String value;
    private final Type type;

    public StringConstant(@Nonnull String str, @Nonnull Type type) {
        this.type = type;
        this.value = str;
    }

    public boolean equals(Object c) {
        return c instanceof StringConstant && ((StringConstant)c).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseStringConstant(this);
    }

    public String toString() {
        String escape = Jimple.escape(this.value);
        if (escape.charAt(0) != '\"') {
            return "\"" + this.value + "\"";
        }
        return escape;
    }

    public String getValue() {
        return this.value;
    }
}

