/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JInstanceOfExpr
implements Expr,
Copyable {
    private final Immediate op;
    private final Type checkType;

    public JInstanceOfExpr(@Nonnull Immediate op, @Nonnull Type checkType) {
        this.op = op;
        this.checkType = checkType;
    }

    public String toString() {
        return this.op.toString() + " " + "instanceof" + " " + this.checkType.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        this.op.toString(up);
        up.literal(" ");
        up.literal("instanceof");
        up.literal(" ");
        up.literal(Jimple.escape(this.checkType.toString()));
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseInstanceOfExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.op.equivHashCode() * 101 + this.checkType.hashCode() * 17;
    }

    public Immediate getOp() {
        return this.op;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.op.getUses());
        list.add(this.op);
        return list;
    }

    @Override
    @Nonnull
    public Type getType() {
        return PrimitiveType.getBoolean();
    }

    public Type getCheckType() {
        return this.checkType;
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseInstanceOfExpr(this);
    }

    @Nonnull
    public JInstanceOfExpr withOp(@Nonnull Immediate op) {
        return new JInstanceOfExpr(op, this.getCheckType());
    }

    @Nonnull
    public JInstanceOfExpr withCheckType(@Nonnull Type checkType) {
        return new JInstanceOfExpr(this.getOp(), checkType);
    }
}

