/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.common.expr.AbstractUnopExpr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JNegExpr
extends AbstractUnopExpr
implements Copyable {
    public JNegExpr(@Nonnull Immediate op) {
        super(op);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseNegExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.getOp().equivHashCode();
    }

    public String toString() {
        return "neg " + this.getOp().toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("neg");
        up.literal(" ");
        this.getOp().toString(up);
    }

    @Override
    @Nonnull
    public Type getType() {
        Immediate op = this.getOp();
        if (op.getType().equals(PrimitiveType.getInt()) || op.getType().equals(PrimitiveType.getByte()) || op.getType().equals(PrimitiveType.getShort()) || op.getType().equals(PrimitiveType.getBoolean()) || op.getType().equals(PrimitiveType.getChar())) {
            return PrimitiveType.getInt();
        }
        if (op.getType().equals(PrimitiveType.getLong())) {
            return PrimitiveType.getLong();
        }
        if (op.getType().equals(PrimitiveType.getDouble())) {
            return PrimitiveType.getDouble();
        }
        if (op.getType().equals(PrimitiveType.getFloat())) {
            return PrimitiveType.getFloat();
        }
        return UnknownType.getInstance();
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseNegExpr(this);
    }

    @Nonnull
    public JNegExpr withOp(@Nonnull Immediate op) {
        return new JNegExpr(op);
    }
}

