/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.ArrayType;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JNewArrayExpr
implements Expr,
Copyable {
    @Nonnull
    private final Type baseType;
    @Nonnull
    private final Immediate size;
    @Nonnull
    private final IdentifierFactory identifierFactory;

    public JNewArrayExpr(@Nonnull Type baseType, @Nonnull Immediate size, @Nonnull IdentifierFactory identifierFactory) {
        this.baseType = baseType;
        this.size = size;
        this.identifierFactory = identifierFactory;
    }

    private static Type simplify(Type baseType, IdentifierFactory identifierFactory) {
        if (baseType instanceof ArrayType) {
            return identifierFactory.getArrayType(((ArrayType)baseType).getBaseType(), ((ArrayType)baseType).getDimension() + 1);
        }
        return identifierFactory.getArrayType(baseType, 1);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseNewArrayExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.size.equivHashCode() * 101 + this.baseType.hashCode() * 17;
    }

    public String toString() {
        return "newarray (" + this.baseType.toString() + ")[" + this.size.toString() + "]";
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("newarray");
        up.literal(" ");
        up.literal("(");
        up.typeSignature(this.baseType);
        up.literal(")");
        up.literal("[");
        this.size.toString(up);
        up.literal("]");
    }

    @Nonnull
    public Type getBaseType() {
        return this.baseType;
    }

    @Nonnull
    public Immediate getSize() {
        return this.size;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        ArrayList<Value> uses = new ArrayList<Value>(this.size.getUses());
        uses.add(this.size);
        return uses;
    }

    @Override
    @Nonnull
    public Type getType() {
        return JNewArrayExpr.simplify(this.baseType, this.identifierFactory);
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseNewArrayExpr(this);
    }

    @Nonnull
    public JNewArrayExpr withBaseType(@Nonnull Type baseType) {
        return new JNewArrayExpr(baseType, this.getSize(), this.identifierFactory);
    }

    @Nonnull
    public JNewArrayExpr withSize(@Nonnull Immediate size) {
        return new JNewArrayExpr(this.baseType, size, this.identifierFactory);
    }
}

