/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.BasicBlock;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JPhiExpr
implements Expr,
Copyable {
    private final List<Local> args;
    private final Map<BasicBlock<?>, Local> blockToArg = new HashMap();
    private final Map<Local, BasicBlock<?>> argToBlock;
    @Nullable
    private final Type type;

    public JPhiExpr(@Nonnull List<Local> args, @Nonnull Map<Local, BasicBlock<?>> argToBlock) {
        this.args = args;
        this.argToBlock = argToBlock;
        int argsSize = args.size();
        if (argsSize > 0) {
            this.type = args.get(0).getType();
            for (int i = 1; i < argsSize; ++i) {
                Local arg = args.get(i);
                if (!arg.getType().equals(this.type)) {
                    throw new RuntimeException("The given args should have the same type!");
                }
                this.blockToArg.put(argToBlock.get(arg), arg);
            }
        } else {
            this.type = null;
        }
    }

    @Nonnull
    public List<Local> getArgs() {
        return new ArrayList<Local>(this.args);
    }

    public int getArgsSize() {
        return this.args.size();
    }

    @Nonnull
    public Local getArg(@Nonnull BasicBlock<?> block) {
        if (this.blockToArg.get(block) == null) {
            throw new RuntimeException("There's no matched arg for the given block " + block);
        }
        return this.blockToArg.get(block);
    }

    @Nonnull
    public Local getArg(int index) {
        if (index >= this.getArgsSize()) {
            throw new RuntimeException("The given index is out of the bound!");
        }
        return this.args.get(index);
    }

    @Nonnull
    public int getArgIndex(@Nonnull BasicBlock<?> block) {
        if (!this.blockToArg.containsKey(block)) {
            throw new RuntimeException("The given block: " + block + " is not contained by PhiExpr!");
        }
        Local arg = this.blockToArg.get(block);
        return this.args.indexOf(arg);
    }

    @Nonnull
    public List<BasicBlock<?>> getBlocks() {
        ArrayList blocks = new ArrayList();
        this.args.forEach(arg -> blocks.add(this.argToBlock.get(arg)));
        return blocks;
    }

    @Nonnull
    public BasicBlock<?> getBlock(@Nonnull Local arg) {
        if (!this.getArgs().contains(arg)) {
            throw new RuntimeException("The given arg: " + arg.toString() + " is not contained by PhiExpr!");
        }
        return this.argToBlock.get(arg);
    }

    @Nonnull
    public BasicBlock<?> getBlock(int index) {
        if (index >= this.getArgsSize()) {
            throw new RuntimeException("The given index is out of the bound!");
        }
        return this.argToBlock.get(this.getArg(index));
    }

    @Nonnull
    public Map<Local, BasicBlock<?>> getArgToBlockMap() {
        return new HashMap(this.argToBlock);
    }

    @Override
    @Nonnull
    public List<Value> getUses() {
        if (this.args == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Value>(this.getArgs());
    }

    @Override
    public int equivHashCode() {
        return Objects.hash(this.args);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseJPhiExpr(this, o);
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("phi");
        up.literal("(");
        if (this.args != null && !this.args.isEmpty()) {
            ArrayList<Local> list = new ArrayList<Local>(this.getArgs());
            list.remove(0).toString(up);
            for (Local arg : list) {
                up.literal(", ");
                arg.toString(up);
            }
        }
        up.literal(")");
    }

    @Nonnull
    public String toString() {
        if (this.args.isEmpty()) {
            return "phi()";
        }
        StringBuilder builder = new StringBuilder();
        ArrayList<Local> argsList = new ArrayList<Local>(this.args);
        builder.append("phi(").append(argsList.get(0).toString());
        for (int i = 1; i < this.getArgsSize(); ++i) {
            builder.append(", ").append(argsList.get(i).toString());
        }
        builder.append(")");
        return builder.toString();
    }

    @Nonnull
    public JPhiExpr withArgs(@Nonnull List<Local> args) {
        return new JPhiExpr(args, this.argToBlock);
    }

    @Nonnull
    public JPhiExpr withArgToBlockMap(@Nonnull Map<Local, BasicBlock<?>> argToBlock) {
        return new JPhiExpr(this.getArgs(), argToBlock);
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.casePhiExpr(this);
    }
}

