/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.signatures.MethodSignature;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JStaticInvokeExpr
extends AbstractInvokeExpr
implements Copyable {
    public JStaticInvokeExpr(@Nonnull MethodSignature method, @Nonnull List<Immediate> args) {
        super(method, args.toArray(new Immediate[0]));
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseStaticInvokeExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.getMethodSignature().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("staticinvoke").append(" ").append(this.getMethodSignature()).append("(");
        this.argsToString(builder);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("staticinvoke");
        up.literal(" ");
        up.methodSignature(this.getMethodSignature());
        up.literal("(");
        this.argsToPrinter(up);
        up.literal(")");
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseStaticInvokeExpr(this);
    }

    @Nonnull
    public JStaticInvokeExpr withMethodSignature(@Nonnull MethodSignature methodSignature) {
        return new JStaticInvokeExpr(methodSignature, this.getArgs());
    }

    @Nonnull
    public JStaticInvokeExpr withArgs(@Nonnull List<Immediate> args) {
        return new JStaticInvokeExpr(this.getMethodSignature(), args);
    }
}

