/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.ref;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.ConcreteRef;
import sootup.core.jimple.visitor.RefVisitor;
import sootup.core.types.ArrayType;
import sootup.core.types.NullType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JArrayRef
implements ConcreteRef,
Copyable {
    private final Local base;
    private final Immediate index;
    private final IdentifierFactory identifierFactory;

    public JArrayRef(@Nonnull Local base, @Nonnull Immediate index, @Nonnull IdentifierFactory identifierFactory) {
        this.base = base;
        this.index = index;
        this.identifierFactory = identifierFactory;
    }

    private Type determineType(@Nonnull IdentifierFactory identifierFactory) {
        Type type = this.base.getType();
        if (type.equals(UnknownType.getInstance())) {
            return UnknownType.getInstance();
        }
        if (type.equals(NullType.getInstance())) {
            return NullType.getInstance();
        }
        ArrayType arrayType = type instanceof ArrayType ? (ArrayType)type : identifierFactory.getArrayType(type, 1);
        if (arrayType.getDimension() == 1) {
            return arrayType.getBaseType();
        }
        return identifierFactory.getArrayType(arrayType.getBaseType(), arrayType.getDimension() - 1);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseArrayRef(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.getBase().equivHashCode() * 101 + this.getIndex().equivHashCode() + 17;
    }

    public String toString() {
        return this.base.toString() + "[" + this.index.toString() + "]";
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        this.base.toString(up);
        up.literal("[");
        this.index.toString(up);
        up.literal("]");
    }

    @Nonnull
    public Local getBase() {
        return this.base;
    }

    @Nonnull
    public Immediate getIndex() {
        return this.index;
    }

    @Override
    @Nonnull
    public List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.base.getUses());
        list.add(this.base);
        list.addAll(this.index.getUses());
        list.add(this.index);
        return list;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.determineType(this.identifierFactory);
    }

    @Override
    public void accept(@Nonnull RefVisitor v) {
        v.caseArrayRef(this);
    }

    @Nonnull
    public JArrayRef withBase(@Nonnull Local base) {
        return new JArrayRef(base, this.getIndex(), this.identifierFactory);
    }

    @Nonnull
    public JArrayRef withIndex(@Nonnull Immediate index) {
        return new JArrayRef(this.getBase(), index, this.identifierFactory);
    }
}

