/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.stmt;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.StmtVisitor;
import sootup.core.model.Body;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JIfStmt
extends BranchingStmt
implements Copyable {
    @Nonnull
    private final AbstractConditionExpr condition;

    public JIfStmt(@Nonnull AbstractConditionExpr condition, @Nonnull StmtPositionInfo positionInfo) {
        super(positionInfo);
        this.condition = condition;
    }

    public String toString() {
        return "if " + this.getCondition();
    }

    @Override
    public void toString(@Nonnull StmtPrinter stmtPrinter) {
        stmtPrinter.literal("if");
        stmtPrinter.literal(" ");
        this.condition.toString(stmtPrinter);
        stmtPrinter.literal(" ");
        stmtPrinter.literal("goto");
        stmtPrinter.literal(" ");
        stmtPrinter.stmtRef(stmtPrinter.getGraph().getBranchTargetsOf(this).get(0), true);
    }

    @Nonnull
    public AbstractConditionExpr getCondition() {
        return this.condition;
    }

    @Override
    @Nonnull
    public List<Stmt> getTargetStmts(@Nonnull Body body) {
        return body.getBranchTargetsOf(this);
    }

    @Override
    public int getExpectedSuccessorCount() {
        return 2;
    }

    @Override
    @Nonnull
    public List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.getCondition().getUses());
        list.add(this.getCondition());
        return list;
    }

    @Override
    public void accept(@Nonnull StmtVisitor sw) {
        sw.caseIfStmt(this);
    }

    @Override
    public boolean fallsThrough() {
        return true;
    }

    @Override
    public boolean equivTo(@Nonnull Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseIfStmt(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.getCondition().equivHashCode();
    }

    @Nonnull
    public JIfStmt withCondition(@Nonnull AbstractConditionExpr condition) {
        return new JIfStmt(condition, this.getPositionInfo());
    }

    @Nonnull
    public JIfStmt withPositionInfo(@Nonnull StmtPositionInfo positionInfo) {
        return new JIfStmt(this.getCondition(), positionInfo);
    }
}

