/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.javabytecode.stmt;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.StmtVisitor;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JRetStmt
extends Stmt
implements Copyable {
    @Nonnull
    private final Value stmtAddress;

    public JRetStmt(@Nonnull Value stmtAddress, @Nonnull StmtPositionInfo positionInfo) {
        super(positionInfo);
        this.stmtAddress = stmtAddress;
    }

    public String toString() {
        return "ret " + this.stmtAddress.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("ret");
        up.literal(" ");
        this.stmtAddress.toString(up);
    }

    @Nonnull
    public Value getStmtAddress() {
        return this.stmtAddress;
    }

    @Override
    @Nonnull
    public List<Value> getUses() {
        List<Value> uses = this.stmtAddress.getUses();
        ArrayList<Value> list = new ArrayList<Value>(uses.size() + 1);
        list.add(this.stmtAddress);
        return list;
    }

    @Override
    public void accept(@Nonnull StmtVisitor sw) {
        sw.caseRetStmt(this);
    }

    @Override
    public boolean fallsThrough() {
        return true;
    }

    @Override
    public boolean branches() {
        return false;
    }

    @Override
    public boolean equivTo(@Nonnull Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseRetStmt(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.stmtAddress.equivHashCode();
    }

    @Nonnull
    public JRetStmt withStmtAddress(@Nonnull Value stmtAddress) {
        return new JRetStmt(stmtAddress, this.getPositionInfo());
    }

    @Nonnull
    public JRetStmt withPositionInfo(@Nonnull StmtPositionInfo positionInfo) {
        return new JRetStmt(this.getStmtAddress(), positionInfo);
    }
}

