/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JAndExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JCmpExpr;
import sootup.core.jimple.common.expr.JCmpgExpr;
import sootup.core.jimple.common.expr.JCmplExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JGeExpr;
import sootup.core.jimple.common.expr.JGtExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JLeExpr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JLtExpr;
import sootup.core.jimple.common.expr.JMulExpr;
import sootup.core.jimple.common.expr.JNeExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JOrExpr;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JSubExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.expr.JXorExpr;
import sootup.core.jimple.visitor.AbstractExprVisitor;

public class ReplaceUseExprVisitor
extends AbstractExprVisitor<Expr> {
    private Value oldUse;
    private Value newUse;
    BasicBlock<?> phiBlock = null;

    public ReplaceUseExprVisitor() {
    }

    public void init(@Nonnull Value oldUse, @Nonnull Value newUse) {
        this.oldUse = oldUse;
        this.newUse = newUse;
    }

    public ReplaceUseExprVisitor(Value oldUse, Value newUse, BasicBlock<?> phiBlock) {
        this.oldUse = oldUse;
        this.newUse = newUse;
        this.phiBlock = phiBlock;
    }

    @Override
    public void caseAddExpr(@Nonnull JAddExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newAddExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseAndExpr(@Nonnull JAndExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newAndExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseCmpExpr(@Nonnull JCmpExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newCmpExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseCmpgExpr(@Nonnull JCmpgExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newCmpgExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseCmplExpr(@Nonnull JCmplExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newCmplExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseDivExpr(@Nonnull JDivExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newDivExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseEqExpr(@Nonnull JEqExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newEqExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseNeExpr(@Nonnull JNeExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newNeExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseGeExpr(@Nonnull JGeExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newGeExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseGtExpr(@Nonnull JGtExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newGtExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseLeExpr(@Nonnull JLeExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newLeExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseLtExpr(@Nonnull JLtExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newLtExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseMulExpr(@Nonnull JMulExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newMulExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseOrExpr(@Nonnull JOrExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newOrExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseRemExpr(@Nonnull JRemExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newRemExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseShlExpr(@Nonnull JShlExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newShlExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseShrExpr(@Nonnull JShrExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newShrExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseUshrExpr(@Nonnull JUshrExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newUshrExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseSubExpr(@Nonnull JSubExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newSubExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseXorExpr(@Nonnull JXorExpr expr) {
        if (expr.getOp1() == this.oldUse && expr.getOp2() == this.oldUse) {
            this.setResult(Jimple.newXorExpr((Immediate)this.newUse, (Immediate)this.newUse));
        } else if (expr.getOp1() == this.oldUse) {
            this.setResult(expr.withOp1((Immediate)this.newUse));
        } else if (expr.getOp2() == this.oldUse) {
            this.setResult(expr.withOp2((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseStaticInvokeExpr(@Nonnull JStaticInvokeExpr expr) {
        boolean isChanged = false;
        ArrayList<Immediate> newArgs = new ArrayList<Immediate>(expr.getArgs());
        int index = 0;
        for (Value value : expr.getArgs()) {
            if (value == this.oldUse) {
                newArgs.set(index, (Immediate)this.newUse);
                isChanged = true;
            }
            ++index;
        }
        if (isChanged) {
            this.setResult(expr.withArgs(newArgs));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseDynamicInvokeExpr(@Nonnull JDynamicInvokeExpr expr) {
        boolean isChanged = false;
        ArrayList<Immediate> newArgs = new ArrayList<Immediate>(expr.getArgs());
        int index = 0;
        for (Value value : expr.getArgs()) {
            if (value == this.oldUse) {
                newArgs.set(index, (Immediate)this.newUse);
                isChanged = true;
            }
            ++index;
        }
        if (isChanged) {
            this.setResult(expr.withMethodArgs(newArgs));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseNewMultiArrayExpr(@Nonnull JNewMultiArrayExpr expr) {
        boolean isChanged = false;
        ArrayList<Immediate> newArgs = new ArrayList<Immediate>(expr.getSizes());
        int index = 0;
        for (Immediate arg : expr.getSizes()) {
            if (arg == this.oldUse) {
                newArgs.set(index, (Immediate)this.newUse);
                isChanged = true;
            }
            ++index;
        }
        if (isChanged) {
            this.setResult(expr.withSizes(newArgs));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseSpecialInvokeExpr(@Nonnull JSpecialInvokeExpr expr) {
        this.instanceInvokeExpr(expr);
    }

    @Override
    public void caseVirtualInvokeExpr(@Nonnull JVirtualInvokeExpr expr) {
        this.instanceInvokeExpr(expr);
    }

    @Override
    public void caseInterfaceInvokeExpr(@Nonnull JInterfaceInvokeExpr expr) {
        this.instanceInvokeExpr(expr);
    }

    private void instanceInvokeExpr(@Nonnull AbstractInstanceInvokeExpr expr) {
        boolean isChanged = false;
        ArrayList<Immediate> newArgs = new ArrayList<Immediate>(expr.getArgs());
        int index = 0;
        for (Immediate arg : expr.getArgs()) {
            if (arg == this.oldUse) {
                newArgs.set(index, (Immediate)this.newUse);
                isChanged = true;
            }
            ++index;
        }
        if (isChanged) {
            this.setResult(expr.withArgs(newArgs));
        }
        if (expr.getBase() == this.oldUse) {
            if (isChanged) {
                this.setResult(((AbstractInstanceInvokeExpr)this.getResult()).withBase((Local)this.newUse));
            } else {
                this.setResult(expr.withBase((Local)this.newUse));
                isChanged = true;
            }
        }
        if (!isChanged) {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseCastExpr(@Nonnull JCastExpr expr) {
        if (expr.getOp() == this.oldUse) {
            this.setResult(expr.withOp((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseInstanceOfExpr(@Nonnull JInstanceOfExpr expr) {
        if (expr.getOp() == this.oldUse) {
            this.setResult(expr.withOp((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseNewArrayExpr(@Nonnull JNewArrayExpr expr) {
        if (expr.getSize() == this.oldUse) {
            this.setResult(expr.withSize((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseLengthExpr(@Nonnull JLengthExpr expr) {
        if (expr.getOp() == this.oldUse) {
            this.setResult(expr.withOp((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void caseNegExpr(@Nonnull JNegExpr expr) {
        if (expr.getOp() == this.oldUse) {
            this.setResult(expr.withOp((Immediate)this.newUse));
        } else {
            this.errorHandler(expr);
        }
    }

    @Override
    public void casePhiExpr(JPhiExpr v) {
        if (this.phiBlock != null && this.newUse instanceof Local && v.getArgs().contains(this.oldUse) && this.newUse.getType().equals(v.getType()) && !v.getArgs().contains(this.newUse)) {
            ArrayList<Local> argsList = new ArrayList<Local>(v.getArgs());
            int index = argsList.indexOf(this.oldUse);
            argsList.set(index, (Local)this.newUse);
            v = v.withArgs(argsList);
            HashMap newArgToBlock = new HashMap();
            List<BasicBlock<?>> blocks = v.getBlocks();
            for (int i = 0; i < v.getArgsSize(); ++i) {
                if (i == index) {
                    newArgToBlock.put((Local)this.newUse, this.phiBlock);
                    continue;
                }
                newArgToBlock.put((Local)argsList.get(i), blocks.get(i));
            }
            this.setResult(v.withArgToBlockMap(newArgToBlock));
        } else {
            this.defaultCaseExpr(v);
        }
    }

    @Override
    public void caseNewExpr(@Nonnull JNewExpr expr) {
        this.defaultCaseExpr(expr);
    }

    @Override
    public void defaultCaseExpr(@Nonnull Expr expr) {
        this.setResult(expr);
    }

    public void errorHandler(@Nonnull Expr expr) {
        this.defaultCaseExpr(expr);
    }
}

