/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ResolveException;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.FieldSubSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.Type;

public abstract class AbstractClass<T extends AbstractClassSource<?>> {
    @Nonnull
    protected final T classSource;

    public AbstractClass(@Nonnull T cs) {
        this.classSource = cs;
    }

    @Nonnull
    public T getClassSource() {
        return this.classSource;
    }

    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract Type getType();

    @Nonnull
    public abstract Set<? extends SootField> getFields();

    @Nonnull
    public abstract Set<? extends SootMethod> getMethods();

    @Nonnull
    public Optional<? extends SootMethod> getMethod(@Nonnull MethodSubSignature subSignature) {
        return this.getMethods().stream().filter(method -> ((MethodSubSignature)((MethodSignature)method.getSignature()).getSubSignature()).equals(subSignature)).findAny();
    }

    @Nonnull
    public Optional<? extends SootField> getField(@Nonnull FieldSubSignature subSignature) {
        return this.getFields().stream().filter(f -> ((FieldSubSignature)((FieldSignature)f.getSignature()).getSubSignature()).equals(subSignature)).findAny();
    }

    @Nonnull
    public Optional<? extends SootField> getField(@Nonnull String name) {
        return this.getFields().stream().filter(field -> ((FieldSignature)field.getSignature()).getName().equals(name)).reduce((l, r) -> {
            throw new ResolveException("ambiguous field: " + name + " in " + ((AbstractClassSource)this.getClassSource()).getClassType(), ((AbstractClassSource)this.getClassSource()).getSourcePath());
        });
    }

    @Nonnull
    public Optional<? extends SootMethod> getMethod(@Nonnull String name, @Nonnull Iterable<? extends Type> parameterTypes) {
        return this.getMethods().stream().filter(method -> ((MethodSignature)method.getSignature()).getName().equals(name) && Iterables.elementsEqual(parameterTypes, method.getParameterTypes())).reduce((l, r) -> {
            throw new ResolveException("ambiguous method: " + name + " in " + ((AbstractClassSource)this.getClassSource()).getClassType(), ((AbstractClassSource)this.getClassSource()).getSourcePath());
        });
    }
}

