/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ResolveException;
import sootup.core.frontend.SootClassSource;
import sootup.core.model.AbstractClass;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.core.util.ImmutableUtils;
import sootup.core.util.printer.JimplePrinter;

public class SootClass<S extends SootClassSource<? extends SootClass<S>>>
extends AbstractClass<S> {
    @Nonnull
    protected final SourceType sourceType;
    @Nonnull
    protected final ClassType classSignature;
    @Nonnull
    private final Supplier<Set<? extends SootMethod>> _lazyMethods = Suppliers.memoize(this::lazyMethodInitializer);
    @Nonnull
    private final Supplier<Set<? extends SootField>> _lazyFields = Suppliers.memoize(this::lazyFieldInitializer);
    private final Supplier<Set<Modifier>> lazyModifiers = Suppliers.memoize(((SootClassSource)this.classSource)::resolveModifiers);
    private final Supplier<Set<? extends ClassType>> lazyInterfaces = Suppliers.memoize(((SootClassSource)this.classSource)::resolveInterfaces);
    private final Supplier<Optional<? extends ClassType>> lazySuperclass = Suppliers.memoize(((SootClassSource)this.classSource)::resolveSuperclass);
    private final Supplier<Optional<? extends ClassType>> lazyOuterClass = Suppliers.memoize(((SootClassSource)this.classSource)::resolveOuterClass);
    private final Supplier<Position> lazyPosition = Suppliers.memoize(((SootClassSource)this.classSource)::resolvePosition);

    public SootClass(@Nonnull S classSource, @Nonnull SourceType sourceType) {
        super(classSource);
        this.sourceType = sourceType;
        this.classSignature = ((AbstractClassSource)classSource).getClassType();
    }

    @Nonnull
    private Set<? extends SootField> lazyFieldInitializer() {
        ImmutableSet<SootField> fields;
        try {
            fields = ImmutableUtils.immutableSetOf(((SootClassSource)this.classSource).resolveFields());
        }
        catch (ResolveException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return fields;
    }

    @Nonnull
    private Set<SootMethod> lazyMethodInitializer() {
        ImmutableSet<SootMethod> methods;
        try {
            methods = ImmutableUtils.immutableSetOf(((SootClassSource)this.classSource).resolveMethods());
        }
        catch (ResolveException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return methods;
    }

    @Override
    @Nonnull
    public Set<? extends SootMethod> getMethods() {
        return this._lazyMethods.get();
    }

    @Override
    @Nonnull
    public Set<? extends SootField> getFields() {
        return this._lazyFields.get();
    }

    @Nonnull
    public Set<Modifier> getModifiers() {
        return this.lazyModifiers.get();
    }

    public Set<? extends ClassType> getInterfaces() {
        return this.lazyInterfaces.get();
    }

    public boolean implementsInterface(@Nonnull ClassType classSignature) {
        for (ClassType sc : this.getInterfaces()) {
            if (!sc.equals(classSignature)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSuperclass() {
        return this.lazySuperclass.get().isPresent();
    }

    public Optional<? extends ClassType> getSuperclass() {
        return this.lazySuperclass.get();
    }

    public boolean hasOuterClass() {
        return this.lazyOuterClass.get().isPresent();
    }

    @Nonnull
    public Optional<? extends ClassType> getOuterClass() {
        return this.lazyOuterClass.get();
    }

    public boolean isInnerClass() {
        return this.hasOuterClass();
    }

    @Override
    @Nonnull
    public ClassType getType() {
        return this.classSignature;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    public boolean isConcrete() {
        return !this.isInterface() && !this.isAbstract();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Nonnull
    public String toString() {
        return this.classSignature.toString();
    }

    @Nonnull
    public String print() {
        StringWriter output = new StringWriter();
        JimplePrinter p = new JimplePrinter(new JimplePrinter.Option[0]);
        p.printTo(this, new PrintWriter(output));
        return output.toString();
    }

    public boolean isApplicationClass() {
        return this.sourceType.equals((Object)SourceType.Application);
    }

    public boolean isLibraryClass() {
        return this.sourceType.equals((Object)SourceType.Library);
    }

    public boolean isPhantomClass() {
        return this.sourceType.equals((Object)SourceType.Phantom);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Nonnull
    public Position getPosition() {
        return this.lazyPosition.get();
    }

    @Override
    @Nonnull
    public S getClassSource() {
        return (S)((SootClassSource)this.classSource);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.classSignature.getFullyQualifiedName();
    }

    @Nonnull
    public SootClass<S> withClassSource(@Nonnull S classSource) {
        return new SootClass<S>(classSource, this.sourceType);
    }

    @Nonnull
    public SootClass<S> withSourceType(@Nonnull SourceType sourceType) {
        return new SootClass<SootClassSource>((SootClassSource)this.classSource, sourceType);
    }
}

