/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.Field;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootClassMember;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.FieldSubSignature;
import sootup.core.types.Type;

public class SootField
extends SootClassMember<FieldSignature>
implements Field {
    public SootField(@Nonnull FieldSignature signature, @Nonnull Iterable<Modifier> modifiers, @Nonnull Position position) {
        super(signature, modifiers, position);
    }

    @Nonnull
    public Type getType() {
        return ((FieldSignature)this.getSignature()).getType();
    }

    @Nonnull
    private String getOriginalStyleDeclaration() {
        if (this.getModifiers().isEmpty()) {
            return ((FieldSubSignature)((FieldSignature)this.getSignature()).getSubSignature()).toString();
        }
        return Modifier.toString(this.getModifiers()) + ' ' + ((FieldSignature)this.getSignature()).getSubSignature();
    }

    @Nonnull
    public String getDeclaration() {
        return this.getOriginalStyleDeclaration();
    }

    @Nonnull
    public SootField withSignature(@Nonnull FieldSignature signature) {
        return new SootField(signature, (Iterable<Modifier>)this.getModifiers(), this.getPosition());
    }

    @Nonnull
    public SootField withModifiers(@Nonnull Iterable<Modifier> modifiers) {
        return new SootField((FieldSignature)this.getSignature(), modifiers, this.getPosition());
    }

    @Nonnull
    public static SignatureStep builder() {
        return new SootFieldBuilder();
    }

    public static class SootFieldBuilder
    implements SignatureStep,
    ModifierStep,
    BuildStep {
        private FieldSignature signature;
        private Iterable<Modifier> modifiers;
        private Position position = NoPositionInformation.getInstance();

        @Nonnull
        protected FieldSignature getSignature() {
            return this.signature;
        }

        @Nonnull
        protected Iterable<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Nonnull
        public Position getPosition() {
            return this.position;
        }

        @Override
        @Nonnull
        public ModifierStep withSignature(@Nonnull FieldSignature signature) {
            this.signature = signature;
            return this;
        }

        @Override
        @Nonnull
        public BuildStep withModifier(@Nonnull Iterable<Modifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        @Override
        @Nonnull
        public BuildStep withPosition(@Nonnull Position position) {
            this.position = position;
            return this;
        }

        @Override
        @Nonnull
        public SootField build() {
            return new SootField(this.getSignature(), this.getModifiers(), this.getPosition());
        }
    }

    public static interface BuildStep {
        public BuildStep withPosition(@Nonnull Position var1);

        @Nonnull
        public SootField build();
    }

    public static interface ModifierStep {
        @Nonnull
        public BuildStep withModifier(@Nonnull Iterable<Modifier> var1);

        @Nonnull
        default public BuildStep withModifiers(@Nonnull Modifier first, Modifier ... rest) {
            return this.withModifier(EnumSet.of(first, rest));
        }
    }

    public static interface SignatureStep {
        @Nonnull
        public ModifierStep withSignature(@Nonnull FieldSignature var1);
    }
}

