/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.signatures;

import com.google.common.base.Objects;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.signatures.SootClassMemberSubSignature;
import sootup.core.types.Type;
import sootup.core.util.printer.StmtPrinter;

public class MethodSubSignature
extends SootClassMemberSubSignature
implements Comparable<MethodSubSignature> {
    @Nonnull
    private final List<Type> parameterTypes;
    private final Supplier<String> _cachedToString = Suppliers.memoize(() -> this.getType() + " " + this.getName() + "(" + this.getParameterTypes().stream().map(Object::toString).collect(Collectors.joining(",")) + ")");

    public MethodSubSignature(@Nonnull String name, @Nonnull Iterable<? extends Type> parameterTypes, @Nonnull Type type) {
        super(name, type);
        this.parameterTypes = ImmutableList.copyOf(parameterTypes);
    }

    @Nonnull
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodSubSignature that = (MethodSubSignature)o;
        return Objects.equal(this.getParameterTypes(), that.getParameterTypes());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.getParameterTypes());
    }

    @Override
    public int compareTo(@Nonnull MethodSubSignature o) {
        return super.compareTo(o);
    }

    @Override
    @Nonnull
    public String toString() {
        return this._cachedToString.get();
    }

    @Override
    public void toString(StmtPrinter printer) {
        printer.typeSignature(this.getType());
        printer.literal(" ");
        printer.literal(Jimple.escape(this.getName()));
        printer.literal("(");
        Iterator<Type> it = this.getParameterTypes().iterator();
        if (it.hasNext()) {
            printer.typeSignature(it.next());
            while (it.hasNext()) {
                printer.literal(",");
                printer.typeSignature(it.next());
            }
        }
        printer.literal(")");
    }
}

