/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.signatures;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import sootup.core.signatures.Signature;
import sootup.core.signatures.SootClassMemberSubSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public abstract class SootClassMemberSignature<V extends SootClassMemberSubSignature>
implements Signature {
    @Nonnull
    private final ClassType declClassSignature;
    @Nonnull
    private final V subSignature;

    public SootClassMemberSignature(@Nonnull ClassType klass, @Nonnull V subSignature) {
        this.declClassSignature = klass;
        this.subSignature = subSignature;
    }

    @Nonnull
    public V getSubSignature() {
        return this.subSignature;
    }

    @Nonnull
    public ClassType getDeclClassType() {
        return this.declClassSignature;
    }

    @Nonnull
    public Type getType() {
        return ((SootClassMemberSubSignature)this.subSignature).getType();
    }

    @Nonnull
    public String getName() {
        return ((SootClassMemberSubSignature)this.subSignature).getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SootClassMemberSignature that = (SootClassMemberSignature)o;
        return Objects.equal(this.declClassSignature, that.declClassSignature) && Objects.equal(this.subSignature, that.subSignature);
    }

    public int hashCode() {
        return Objects.hashCode(this.declClassSignature, this.subSignature);
    }

    @Nonnull
    public String toString() {
        return "<" + this.declClassSignature + ": " + this.getSubSignature() + '>';
    }
}

