/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.typehierarchy;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.core.frontend.ResolveException;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.model.Method;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public final class MethodDispatchResolver {
    private MethodDispatchResolver() {
    }

    @Nonnull
    public static Set<MethodSignature> resolveAbstractDispatch(View<? extends SootClass<?>> view, MethodSignature m3) {
        TypeHierarchy hierarchy = view.getTypeHierarchy();
        return hierarchy.subtypesOf(m3.getDeclClassType()).stream().map(subtype -> (SootClass)view.getClass((ClassType)subtype).orElseThrow(() -> new ResolveException("Could not resolve " + subtype + ", but found it in hierarchy."))).flatMap(abstractClass -> abstractClass.getMethods().stream()).filter(potentialTarget -> MethodDispatchResolver.canDispatch(m3, (MethodSignature)potentialTarget.getSignature(), hierarchy)).filter(method -> !method.isAbstract()).map(Method::getSignature).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<MethodSignature> resolveAbstractDispatchInClasses(View<? extends SootClass<?>> view, MethodSignature m3, Set<ClassType> classes) {
        TypeHierarchy hierarchy = view.getTypeHierarchy();
        return hierarchy.subtypesOf(m3.getDeclClassType()).stream().map(subtype -> (SootClass)view.getClass((ClassType)subtype).orElseThrow(() -> new ResolveException("Could not resolve " + subtype + ", but found it in hierarchy."))).filter(c -> classes.contains(c.getType())).flatMap(abstractClass -> abstractClass.getMethods().stream()).filter(potentialTarget -> MethodDispatchResolver.canDispatch(m3, (MethodSignature)potentialTarget.getSignature(), hierarchy)).filter(method -> !method.isAbstract()).map(Method::getSignature).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<MethodSignature> resolveAbstractDispatchInClasses(View<? extends SootClass<?>> view, MethodSignature m3, Set<ClassType> classes, Set<MethodSignature> filteredSignatures) {
        Set<MethodSignature> allSignatures = MethodDispatchResolver.resolveAbstractDispatch(view, m3);
        HashSet<MethodSignature> signatureInClasses = Sets.newHashSet();
        allSignatures.forEach(methodSignature -> {
            if (classes.contains(methodSignature.getDeclClassType())) {
                signatureInClasses.add((MethodSignature)methodSignature);
            } else {
                filteredSignatures.add((MethodSignature)methodSignature);
            }
        });
        return signatureInClasses;
    }

    public static boolean canDispatch(MethodSignature called, MethodSignature potentialTarget, TypeHierarchy hierarchy) {
        return called.getName().equals(potentialTarget.getName()) && called.getParameterTypes().equals(potentialTarget.getParameterTypes()) && (called.getType().equals(potentialTarget.getType()) || hierarchy.isSubtype(called.getType(), potentialTarget.getType()));
    }

    @Nonnull
    public static MethodSignature resolveConcreteDispatch(View<? extends SootClass<?>> view, MethodSignature m3) {
        TypeHierarchy hierarchy = view.getTypeHierarchy();
        ClassType superClassType = m3.getDeclClassType();
        do {
            ClassType finalSuperClassType = superClassType;
            SootClass<?> superClass = view.getClass(superClassType).orElseThrow(() -> new ResolveException("Did not find class " + finalSuperClassType + " in View"));
            SootMethod concreteMethod = superClass.getMethods().stream().filter(potentialTarget -> MethodDispatchResolver.canDispatch(m3, (MethodSignature)potentialTarget.getSignature(), hierarchy)).findAny().orElse(null);
            if (concreteMethod == null || concreteMethod.isAbstract()) continue;
            return (MethodSignature)concreteMethod.getSignature();
        } while ((superClassType = hierarchy.superClassOf(superClassType)) != null);
        throw new ResolveException("Could not find concrete method for " + m3);
    }

    @Nonnull
    public static MethodSignature resolveSpecialDispatch(View<? extends SootClass<?>> view, JSpecialInvokeExpr specialInvokeExpr, MethodSignature container) {
        MethodSignature specialMethodSig = specialInvokeExpr.getMethodSignature();
        if (((MethodSubSignature)specialMethodSig.getSubSignature()).getName().equals("<init>")) {
            return specialMethodSig;
        }
        SootMethod specialMethod = view.getClass(specialMethodSig.getDeclClassType()).flatMap(cl -> cl.getMethod((MethodSubSignature)specialMethodSig.getSubSignature())).orElse(null);
        if (specialMethod != null && specialMethod.isPrivate()) {
            return specialMethodSig;
        }
        if (view.getTypeHierarchy().isSubtype(container.getDeclClassType(), specialMethodSig.getDeclClassType())) {
            return MethodDispatchResolver.resolveConcreteDispatch(view, specialMethodSig);
        }
        return specialMethodSig;
    }
}

