/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;

public interface TypeHierarchy {
    @Nonnull
    public Set<ClassType> implementersOf(@Nonnull ClassType var1);

    @Nonnull
    public Set<ClassType> subclassesOf(@Nonnull ClassType var1);

    @Nonnull
    public Set<ClassType> implementedInterfacesOf(@Nonnull ClassType var1);

    @Nonnull
    public Set<ClassType> subtypesOf(@Nonnull ClassType var1);

    @Nonnull
    public Set<ClassType> directSubtypesOf(@Nonnull ClassType var1);

    @Nullable
    public ClassType superClassOf(@Nonnull ClassType var1);

    default public boolean isSubtype(@Nonnull Type supertype, @Nonnull Type potentialSubtype) {
        if (!(supertype instanceof ReferenceType) || !(potentialSubtype instanceof ReferenceType)) {
            return false;
        }
        if (supertype instanceof NullType) {
            return false;
        }
        if (potentialSubtype instanceof NullType) {
            return true;
        }
        if (supertype instanceof ArrayType) {
            if (!(potentialSubtype instanceof ArrayType)) {
                return false;
            }
            ArrayType superArrayType = (ArrayType)supertype;
            ArrayType potentialSubArrayType = (ArrayType)potentialSubtype;
            if (superArrayType.getBaseType() instanceof PrimitiveType) {
                return false;
            }
            if (!1.$assertionsDisabled && !(superArrayType.getBaseType() instanceof ReferenceType)) {
                throw new AssertionError();
            }
            if (this.isSubtype(superArrayType.getBaseType(), potentialSubArrayType.getBaseType()) && potentialSubArrayType.getDimension() == superArrayType.getDimension()) {
                return true;
            }
            if (superArrayType.getBaseType() instanceof ClassType && (((ClassType)superArrayType.getBaseType()).getFullyQualifiedName().equals("java.lang.Object") || ((ClassType)superArrayType.getBaseType()).getFullyQualifiedName().equals("java.io.Serializable") || ((ClassType)superArrayType.getBaseType()).getFullyQualifiedName().equals("java.lang.Cloneable"))) {
                return potentialSubArrayType.getDimension() > superArrayType.getDimension();
            }
            return false;
        }
        if (supertype instanceof ClassType) {
            if (potentialSubtype instanceof ClassType) {
                return supertype.equals(this.superClassOf((ClassType)potentialSubtype)) || this.superClassesOf((ClassType)potentialSubtype).contains(supertype) || this.implementedInterfacesOf((ClassType)potentialSubtype).contains(supertype);
            }
            if (potentialSubtype instanceof ArrayType) {
                String fullyQualifiedName = ((ClassType)supertype).getFullyQualifiedName();
                return fullyQualifiedName.equals("java.lang.Object") || fullyQualifiedName.equals("java.io.Serializable") || fullyQualifiedName.equals("java.lang.Cloneable");
            }
            throw new AssertionError((Object)"potentialSubtype has unexpected type");
        }
        throw new AssertionError((Object)"supertype has unexpected type");
    }

    @Nonnull
    default public List<ClassType> superClassesOf(@Nonnull ClassType classType) {
        ArrayList<ClassType> superClasses = new ArrayList<ClassType>();
        ClassType currentSuperClass = this.superClassOf(classType);
        while (currentSuperClass != null) {
            superClasses.add(currentSuperClass);
            currentSuperClass = this.superClassOf(currentSuperClass);
        }
        return superClasses;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

