/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.typehierarchy;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.frontend.ResolveException;
import sootup.core.model.SootClass;
import sootup.core.typehierarchy.MutableTypeHierarchy;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class ViewTypeHierarchy
implements MutableTypeHierarchy {
    private static final Logger log = LoggerFactory.getLogger(ViewTypeHierarchy.class);
    private final Supplier<ScanResult> lazyScanResult = Suppliers.memoize(this::scanView);
    @Nonnull
    private final View<? extends SootClass> view;

    public ViewTypeHierarchy(@Nonnull View<? extends SootClass> view) {
        this.view = view;
    }

    @Override
    @Nonnull
    public Set<ClassType> implementersOf(@Nonnull ClassType interfaceType) {
        ScanResult.Vertex vertex = this.lazyScanResult.get().typeToVertex.get(interfaceType);
        if (vertex == null) {
            throw new ResolveException("Could not find " + interfaceType + " in hierarchy.");
        }
        if (vertex.type != ScanResult.VertexType.Interface) {
            throw new IllegalArgumentException(interfaceType + " is not an interface.");
        }
        return this.subtypesOf(interfaceType);
    }

    @Override
    @Nonnull
    public Set<ClassType> subclassesOf(@Nonnull ClassType classType) {
        ScanResult.Vertex vertex = this.lazyScanResult.get().typeToVertex.get(classType);
        if (vertex == null) {
            throw new ResolveException("Could not find " + classType + " in hierarchy.");
        }
        if (vertex.type != ScanResult.VertexType.Class) {
            throw new IllegalArgumentException(classType + " is not a class.");
        }
        return this.subtypesOf(classType);
    }

    @Override
    @Nonnull
    public Set<ClassType> subtypesOf(@Nonnull ClassType type) {
        ScanResult scanResult = this.lazyScanResult.get();
        ScanResult.Vertex vertex = scanResult.typeToVertex.get(type);
        if (vertex == null) {
            throw new ResolveException("Could not find " + type + " in hierarchy.");
        }
        HashSet<ClassType> subclasses = new HashSet<ClassType>();
        ViewTypeHierarchy.visitSubgraph(scanResult.graph, vertex, false, subvertex -> subclasses.add(subvertex.javaClassType));
        return subclasses;
    }

    @Override
    @Nonnull
    public Set<ClassType> directSubtypesOf(@Nonnull ClassType type) {
        ScanResult scanResult = this.lazyScanResult.get();
        ScanResult.Vertex vertex = scanResult.typeToVertex.get(type);
        if (vertex == null) {
            throw new ResolveException("Could not find " + type + " in hierarchy.");
        }
        HashSet<ClassType> subclasses = new HashSet<ClassType>();
        Graph<ScanResult.Vertex, ScanResult.Edge> graph = scanResult.graph;
        switch (vertex.type) {
            case Interface: {
                graph.incomingEdgesOf(vertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyImplements || edge.type == ScanResult.EdgeType.InterfaceDirectlyExtends).map(graph::getEdgeSource).forEach(directSubclass -> subclasses.add(directSubclass.javaClassType));
                break;
            }
            case Class: {
                graph.incomingEdgesOf(vertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyExtends).map(graph::getEdgeSource).forEach(directSubclass -> subclasses.add(directSubclass.javaClassType));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown vertex type!");
            }
        }
        return subclasses;
    }

    @Nonnull
    private List<ScanResult.Vertex> superClassesOf(@Nonnull ScanResult.Vertex classVertex, boolean includingSelf) {
        ScanResult scanResult = this.lazyScanResult.get();
        Graph<ScanResult.Vertex, ScanResult.Edge> graph = scanResult.graph;
        ArrayList<ScanResult.Vertex> superClasses = new ArrayList<ScanResult.Vertex>();
        if (includingSelf) {
            superClasses.add(classVertex);
        }
        Optional<ScanResult.Vertex> superClass = graph.outgoingEdgesOf(classVertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyExtends).map(graph::getEdgeTarget).findAny();
        while (superClass.isPresent()) {
            superClasses.add(superClass.get());
            superClass = graph.outgoingEdgesOf(superClass.get()).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyExtends).map(graph::getEdgeTarget).findAny();
        }
        return superClasses;
    }

    private Stream<ScanResult.Vertex> directlyImplementedInterfacesOf(ScanResult.Vertex classVertex) {
        Graph<ScanResult.Vertex, ScanResult.Edge> graph = this.lazyScanResult.get().graph;
        return graph.outgoingEdgesOf(classVertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyImplements).map(graph::getEdgeTarget);
    }

    private Stream<ScanResult.Vertex> directlyExtendedInterfacesOf(ScanResult.Vertex interfaceVertex) {
        Graph<ScanResult.Vertex, ScanResult.Edge> graph = this.lazyScanResult.get().graph;
        return graph.outgoingEdgesOf(interfaceVertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.InterfaceDirectlyExtends).map(graph::getEdgeTarget);
    }

    @Override
    @Nonnull
    public Set<ClassType> implementedInterfacesOf(@Nonnull ClassType type) {
        ScanResult scanResult = this.lazyScanResult.get();
        ScanResult.Vertex vertex = scanResult.typeToVertex.get(type);
        if (vertex == null) {
            throw new ResolveException("Could not find " + type + " in hierarchy for view " + this.view);
        }
        switch (vertex.type) {
            case Class: {
                List<ScanResult.Vertex> superClasses = this.superClassesOf(vertex, true);
                return superClasses.stream().flatMap(this::directlyImplementedInterfacesOf).flatMap(this::selfAndImplementedInterfaces).collect(Collectors.toSet());
            }
            case Interface: {
                return this.directlyExtendedInterfacesOf(vertex).flatMap(this::selfAndImplementedInterfaces).collect(Collectors.toSet());
            }
        }
        throw new AssertionError((Object)"Unexpected vertex type!");
    }

    @Nonnull
    private Stream<ClassType> selfAndImplementedInterfaces(ScanResult.Vertex vertex) {
        ScanResult scanResult = this.lazyScanResult.get();
        Graph<ScanResult.Vertex, ScanResult.Edge> graph = scanResult.graph;
        Stream<ScanResult.Vertex> extendedInterfaces = graph.outgoingEdgesOf(vertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.InterfaceDirectlyExtends).map(graph::getEdgeTarget);
        return Stream.concat(Stream.of(vertex.javaClassType), extendedInterfaces.flatMap(this::selfAndImplementedInterfaces));
    }

    @Override
    @Nullable
    public ClassType superClassOf(@Nonnull ClassType classType) {
        return this.sootClassFor(classType).getSuperclass().orElse(null);
    }

    private static void visitSubgraph(Graph<ScanResult.Vertex, ScanResult.Edge> graph, ScanResult.Vertex vertex, boolean includeSelf, Consumer<ScanResult.Vertex> visitor) {
        if (includeSelf) {
            visitor.accept(vertex);
        }
        switch (vertex.type) {
            case Interface: {
                graph.incomingEdgesOf(vertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyImplements || edge.type == ScanResult.EdgeType.InterfaceDirectlyExtends).map(graph::getEdgeSource).forEach(directSubtype -> ViewTypeHierarchy.visitSubgraph(graph, directSubtype, true, visitor));
                break;
            }
            case Class: {
                graph.incomingEdgesOf(vertex).stream().filter(edge -> edge.type == ScanResult.EdgeType.ClassDirectlyExtends).map(graph::getEdgeSource).forEach(directSubclass -> ViewTypeHierarchy.visitSubgraph(graph, directSubclass, true, visitor));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown vertex type!");
            }
        }
    }

    private ScanResult scanView() {
        long startNanos = System.nanoTime();
        HashMap typeToVertex = new HashMap();
        SimpleDirectedGraph graph = new SimpleDirectedGraph(null, null, false);
        this.view.getClasses().stream().forEach(sootClass -> ViewTypeHierarchy.addSootClassToGraph(sootClass, typeToVertex, graph));
        double runtimeMs = (double)(System.nanoTime() - startNanos) / 1000000.0;
        log.info("Type hierarchy scan took " + runtimeMs + " ms");
        return new ScanResult(typeToVertex, graph);
    }

    private static void addSootClassToGraph(SootClass<?> sootClass, Map<ClassType, ScanResult.Vertex> typeToVertex, Graph<ScanResult.Vertex, ScanResult.Edge> graph) {
        if (sootClass.isInterface()) {
            ScanResult.Vertex vertex = typeToVertex.computeIfAbsent(sootClass.getType(), type -> ViewTypeHierarchy.createAndAddInterfaceVertex(graph, type));
            for (ClassType extendedInterface : sootClass.getInterfaces()) {
                ScanResult.Vertex extendedInterfaceVertex = typeToVertex.computeIfAbsent(extendedInterface, type -> ViewTypeHierarchy.createAndAddInterfaceVertex(graph, type));
                graph.addEdge(vertex, extendedInterfaceVertex, new ScanResult.Edge(ScanResult.EdgeType.InterfaceDirectlyExtends));
            }
        } else {
            ScanResult.Vertex vertex = typeToVertex.computeIfAbsent(sootClass.getType(), type -> ViewTypeHierarchy.createAndAddClassVertex(graph, type));
            for (ClassType implementedInterface : sootClass.getInterfaces()) {
                ScanResult.Vertex implementedInterfaceVertex = typeToVertex.computeIfAbsent(implementedInterface, type -> ViewTypeHierarchy.createAndAddInterfaceVertex(graph, type));
                graph.addEdge(vertex, implementedInterfaceVertex, new ScanResult.Edge(ScanResult.EdgeType.ClassDirectlyImplements));
            }
            sootClass.getSuperclass().ifPresent(superClass -> {
                ScanResult.Vertex superClassVertex = typeToVertex.computeIfAbsent((ClassType)superClass, type -> ViewTypeHierarchy.createAndAddClassVertex(graph, type));
                graph.addEdge(vertex, superClassVertex, new ScanResult.Edge(ScanResult.EdgeType.ClassDirectlyExtends));
            });
        }
    }

    @Nonnull
    private static ScanResult.Vertex createAndAddClassVertex(Graph<ScanResult.Vertex, ScanResult.Edge> graph, ClassType type) {
        ScanResult.Vertex classVertex = new ScanResult.Vertex(type, ScanResult.VertexType.Class);
        graph.addVertex(classVertex);
        return classVertex;
    }

    @Nonnull
    private static ScanResult.Vertex createAndAddInterfaceVertex(Graph<ScanResult.Vertex, ScanResult.Edge> graph, ClassType type) {
        ScanResult.Vertex interfaceVertex = new ScanResult.Vertex(type, ScanResult.VertexType.Interface);
        graph.addVertex(interfaceVertex);
        return interfaceVertex;
    }

    @Nonnull
    private SootClass<?> sootClassFor(@Nonnull ClassType classType) {
        return this.view.getClassOrThrow(classType);
    }

    @Override
    public void addType(SootClass sootClass) {
        ScanResult scanResult = this.lazyScanResult.get();
        ViewTypeHierarchy.addSootClassToGraph(sootClass, scanResult.typeToVertex, scanResult.graph);
    }

    static class ScanResult {
        @Nonnull
        final Map<ClassType, Vertex> typeToVertex;
        @Nonnull
        final Graph<Vertex, Edge> graph;

        private ScanResult(@Nonnull Map<ClassType, Vertex> typeToVertex, @Nonnull Graph<Vertex, Edge> graph) {
            this.typeToVertex = typeToVertex;
            this.graph = graph;
        }

        static class Edge {
            @Nonnull
            final EdgeType type;

            Edge(@Nonnull EdgeType type) {
                this.type = type;
            }
        }

        static enum EdgeType {
            InterfaceDirectlyExtends,
            ClassDirectlyImplements,
            ClassDirectlyExtends;

        }

        static class Vertex {
            @Nonnull
            final ClassType javaClassType;
            @Nonnull
            final VertexType type;

            Vertex(@Nonnull ClassType javaClassType, @Nonnull VertexType type) {
                this.javaClassType = javaClassType;
                this.type = type;
            }
        }

        static enum VertexType {
            Class,
            Interface;

        }
    }
}

