/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.types;

import javax.annotation.Nonnull;
import sootup.core.jimple.visitor.TypeVisitor;
import sootup.core.types.Type;

public abstract class PrimitiveType
extends Type {
    @Nonnull
    private final String name;

    private PrimitiveType(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String toString() {
        return this.name;
    }

    public static boolean isIntLikeType(Type t) {
        return t == IntType.getInstance() || t == ByteType.getInstance() || t == ShortType.getInstance() || t == CharType.getInstance() || t == BooleanType.getInstance();
    }

    @Nonnull
    public static ByteType getByte() {
        return ByteType.getInstance();
    }

    @Nonnull
    public static ShortType getShort() {
        return ShortType.getInstance();
    }

    @Nonnull
    public static IntType getInt() {
        return IntType.getInstance();
    }

    @Nonnull
    public static LongType getLong() {
        return LongType.getInstance();
    }

    @Nonnull
    public static FloatType getFloat() {
        return FloatType.getInstance();
    }

    @Nonnull
    public static DoubleType getDouble() {
        return DoubleType.getInstance();
    }

    @Nonnull
    public static CharType getChar() {
        return CharType.getInstance();
    }

    @Nonnull
    public static BooleanType getBoolean() {
        return BooleanType.getInstance();
    }

    public static class BooleanType
    extends PrimitiveType {
        private static final BooleanType INSTANCE = new BooleanType();

        private BooleanType() {
            super("boolean");
        }

        public static BooleanType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseBooleanType();
        }
    }

    public static class CharType
    extends PrimitiveType {
        private static final CharType INSTANCE = new CharType();

        private CharType() {
            super("char");
        }

        public static CharType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseCharType();
        }
    }

    public static class FloatType
    extends PrimitiveType {
        private static final FloatType INSTANCE = new FloatType();

        private FloatType() {
            super("float");
        }

        public static FloatType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseFloatType();
        }
    }

    public static class LongType
    extends PrimitiveType {
        private static final LongType INSTANCE = new LongType();

        private LongType() {
            super("long");
        }

        public static LongType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseLongType();
        }
    }

    public static class DoubleType
    extends PrimitiveType {
        private static final DoubleType INSTANCE = new DoubleType();

        private DoubleType() {
            super("double");
        }

        public static DoubleType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseDoubleType();
        }
    }

    public static class IntType
    extends PrimitiveType {
        private static final IntType INSTANCE = new IntType();

        public IntType() {
            super("int");
        }

        public static IntType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseIntType();
        }
    }

    public static class ShortType
    extends PrimitiveType {
        private static final ShortType INSTANCE = new ShortType();

        private ShortType() {
            super("short");
        }

        public static ShortType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseShortType();
        }
    }

    public static class ByteType
    extends PrimitiveType {
        private static final ByteType INSTANCE = new ByteType();

        private ByteType() {
            super("byte");
        }

        public static ByteType getInstance() {
            return INSTANCE;
        }

        @Override
        public void accept(@Nonnull TypeVisitor v) {
            v.caseByteType();
        }
    }
}

