/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.types.ClassType;

public class DotExporter {
    public static String buildGraph(@Nonnull StmtGraph<?> graph) {
        Collection<BasicBlock<?>> blocks;
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G {\n").append("\tcompound=true\n").append("\tlabelloc=b\n").append("\tstyle=filled\n").append("\tcolor=gray90\n").append("\tnode [shape=box,style=filled,color=white]\n").append("\tedge [fontsize=10,arrowsize=1.5,fontcolor=grey40]\n").append("\tfontsize=10\n\n");
        Stmt startingStmt = graph.getStartingStmt();
        int i = 0;
        try {
            blocks = graph.getBlocksSorted();
        }
        catch (Exception e) {
            blocks = graph.getBlocks();
        }
        HashSet<BasicBlock<?>> drawnBlocks = Sets.newHashSetWithExpectedSize(blocks.size());
        for (BasicBlock<?> block : blocks) {
            Map<ClassType, ?> exceptionalSuccessors;
            sb.append("//  lines [").append(block.getHead().getPositionInfo().getStmtPosition().getFirstLine()).append(": ").append(block.getTail().getPositionInfo().getStmtPosition().getFirstLine()).append("] \n");
            sb.append("\tsubgraph cluster_").append(block.hashCode()).append(" { \n").append("\t\tlabel = \"Block #").append(++i).append("\"\n");
            List<Stmt> stmts = block.getStmts();
            drawnBlocks.add(block);
            for (Stmt stmt : stmts) {
                sb.append("\t\t").append(stmt.hashCode()).append("[label=\"").append(DotExporter.escape(stmt.toString())).append("\"");
                if (startingStmt == stmt || stmt.getExpectedSuccessorCount() == 0) {
                    sb.append(",shape=Mdiamond,color=grey50,fillcolor=white");
                }
                sb.append("]\n");
            }
            if (stmts.size() > 1) {
                sb.append("\n\t\t");
                for (Stmt stmt : stmts) {
                    sb.append(stmt.hashCode()).append(" -> ");
                }
                sb.delete(sb.length() - 4, sb.length());
                sb.append("\n");
            }
            sb.append("\t}\n");
            List<?> successors = block.getSuccessors();
            if (successors.size() > 0) {
                Stmt tailStmt = block.getTail();
                Iterator<Object> labelIt = tailStmt instanceof BranchingStmt ? (tailStmt instanceof JIfStmt ? Arrays.asList("false", "true").iterator() : (tailStmt instanceof JSwitchStmt ? ((JSwitchStmt)tailStmt).getValues().stream().map(s2 -> "case " + s2).iterator() : Collections.emptyIterator())) : Collections.emptyIterator();
                for (BasicBlock successorBlock : successors) {
                    sb.append("\t").append(tailStmt.hashCode());
                    boolean successorIsAlreadyDrawn = drawnBlocks.contains(successorBlock);
                    if (successorIsAlreadyDrawn) {
                        sb.append(":e -> ");
                    } else {
                        sb.append(":s -> ");
                    }
                    sb.append(successorBlock.getHead().hashCode()).append(":n");
                    if (labelIt.hasNext()) {
                        sb.append("[");
                        if (labelIt.hasNext()) {
                            sb.append("label=\"").append((String)labelIt.next()).append("\"");
                        }
                        sb.append("]");
                    }
                    sb.append("\n");
                }
            }
            if ((exceptionalSuccessors = block.getExceptionalSuccessors()).size() > 0) {
                sb.append("\t//exceptional edges \n");
                for (Map.Entry<ClassType, ?> successorBlock : exceptionalSuccessors.entrySet()) {
                    sb.append("\t").append(block.getTail().hashCode()).append(":e -> ").append(((BasicBlock)successorBlock.getValue()).getHead().hashCode()).append(":n [label=\"\t").append(successorBlock.getKey().toString()).append("\"color=red,ltail=\"cluster_").append(block.hashCode()).append("\"]\n");
                }
            }
            sb.append("\n");
        }
        return sb.append("}").toString();
    }

    private static String escape(String str) {
        return StringEscapeUtils.escapeXml10(str);
    }

    public static String createUrlToWebeditor(@Nonnull StmtGraph<?> graph) {
        try {
            return "http://magjac.com/graphviz-visual-editor/?dot=" + URLEncoder.encode(DotExporter.buildGraph(graph), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

